<?php

namespace AmeliaBooking\Infrastructure\WP\Translations;

/**
 * Class LiteBackendStrings
 *
 * @package AmeliaBooking\Infrastructure\WP\Translations
 *
 * @SuppressWarnings(ExcessiveMethodLength)
 * @SuppressWarnings(ExcessiveClassLength)
 * @phpcs:disable
 */
class LiteBackendStrings
{
    /**
     * @var array|null
     */
    protected static $liteStrings = null;

    /**
     * Returns a single settings string by key
     *
     * @param string $key
     *
     * @return string
     */
    public static function get($key)
    {
        if (self::$liteStrings === null) {
            self::$liteStrings = self::getAllStrings();
        }

        return self::$liteStrings[$key] ?? '';
    }

    /**
     * Returns the array for the settings strings
     *
     * @return array
     */
    public static function getAllStrings()
    {
        return [
            'admin'                                            => __('Admin', 'wpamelia'),
            'add_date'                                         => __('Add Date', 'wpamelia'), // Used in Redesign
            'add_period'                                       => __('Add period', 'wpamelia'), // Used in Redesign
            'all_services'                                     => __('All services', 'wpamelia'), // Used in Redesign
            'appointment'                                      => __('Appointment', 'wpamelia'), // Used in Redesign
            'appointments'                                     => __('Appointments', 'wpamelia'), // Used in Redesign
            'approved'                                         => __('Approved', 'wpamelia'), // Used in Redesign
            'attendee'                                         => __('Attendee', 'wpamelia'), // Used in Redesign
            'booked'                                           => __('Booked', 'wpamelia'), // Used in Redesign
            'booking'                                          => __('Booking', 'wpamelia'), // Used in Redesign
            'bookings'                                         => __('Bookings', 'wpamelia'), // Used in Redesign
            'cancel'                                           => __('Cancel', 'wpamelia'),
            'canceled'                                         => __('Canceled', 'wpamelia'), // Used in Redesign
            'content_mode_tooltip'                             => __('HTML formatting may be overridden by plain text formatting upon switching between modes.', 'wpamelia'), // Used in Redesign
            'close'                                            => __('Close', 'wpamelia'), // Used in Redesign
            'closed'                                           => __('Closed', 'wpamelia'), // Used in Redesign
            'csv_delimiter'                                    => __('Select delimiter', 'wpamelia'), // Used in Redesign
            'csv_delimiter_comma'                              => __('Comma (,)', 'wpamelia'),
            'continue'                                         => __('Continue', 'wpamelia'), // Used in Redesign
            'coupon_code'                                      => __('Coupon code', 'wpamelia'), // Used in Redesign | Updated
            'customer'                                         => __('Customer', 'wpamelia'), // Used in Redesign
            'minutes'                                          => __('Minutes', 'wpamelia'),
            'hour'                                             => __('Hour', 'wpamelia'), // Used in Redesign
            'hours'                                            => __('Hours', 'wpamelia'),
            'day'                                              => __('Day', 'wpamelia'), // Used in Redesign
            'days'                                             => __('Days', 'wpamelia'), // Used in Redesign
            'week'                                             => __('Week', 'wpamelia'), // Used in Redesign
            'weeks'                                            => __('Weeks', 'wpamelia'), // Used in Redesign
            'month'                                            => __('Month', 'wpamelia'), // Used in Redesign
            'months'                                           => __('Months', 'wpamelia'), // Used in Redesign
            'year'                                             => __('Year', 'wpamelia'), // Used in Redesign
            'date'                                             => __('Date', 'wpamelia'), // Used in Redesign
            'delete'                                           => __('Delete', 'wpamelia'), // Used in Redesign
            'description'                                      => __('Description', 'wpamelia'),
            'details'                                          => __('Details', 'wpamelia'), // Used in Redesign
            'disabled'                                         => __('Disabled', 'wpamelia'), // Used in Redesign
            'duration'                                         => __('Duration', 'wpamelia'), // Used in Redesign
            'duplicate'                                        => __('Duplicate', 'wpamelia'), // Used in Redesign
            'edit'                                             => __('Edit', 'wpamelia'), // Used in Redesign
            'employee'                                         => __('Employee', 'wpamelia'), // Used in Redesign
            'employees'                                        => __('Employees', 'wpamelia'), // Used in Redesign
            'employee_badge'                                   => __('Employee Badge', 'wpamelia'), // Used in Redesign
            'employee_badges'                                  => __('Employee badges', 'wpamelia'),
            'enter_email_warning'                              => __('Please enter an email.', 'wpamelia'), // Used in Redesign  Updated
            'enter_valid_email_warning'                        => __('Please enter a valid email address', 'wpamelia'), // Used in Redesign  Updated
            'error'                                            => __('Error', 'wpamelia'),
            'event'                                            => __('Event', 'wpamelia'), // Used in Redesign
            'events'                                           => __('Events', 'wpamelia'), // Used in Redesign
            'export'                                           => __('Export', 'wpamelia'), // Used in Redesign
            'extra'                                            => __('Extra', 'wpamelia'), // Used in Redesign
            'extras'                                           => __('Extras', 'wpamelia'), // Used in Redesign
            'extras_total_price'                               => __('Extras total price', 'wpamelia'),
            'google_calendar'                                  => __('Google Calendar', 'wpamelia'), // Used in Redesign
            'google_meet_join'                                 => __('Join with Google Meet', 'wpamelia'),
            'outlook_calendar'                                 => __('Outlook Calendar', 'wpamelia'), // Used in Redesign
            'microsoft_teams_join'                             => __('Join with Microsoft Teams', 'wpamelia'),
            'apple_calendar'                                   => __('Apple Calendar', 'wpamelia'), // Used in Redesign
            'h'                                                => __('h', 'wpamelia'), // Used in Redesign
            'id'                                               => __('ID', 'wpamelia'), // Used in Redesign
            'lesson_space'                                     => __('Lesson Space', 'wpamelia'), // Used in Redesign
            'licence_description'                              => __('Interested in unlocking this feature?', 'wpamelia'),
            'licence_start_description'                        => __('Available from Starter license', 'wpamelia'),
            'licence_basic_description'                        => __('Available from Standard license', 'wpamelia'),
            'licence_pro_description'                          => __('Available from Pro license', 'wpamelia'),
            'licence_dev_description'                          => __('Available in Elite licence', 'wpamelia'),
            'licence_button_text'                              => __('Upgrade', 'wpamelia'),
            'delete_amelia_short'                              => __('Delete Amelia content', 'wpamelia'),
            'delete_amelia'                                    => __('Delete tables, roles, files and settings once the Amelia plugin is deleted.', 'wpamelia'),
            'delete_amelia_tooltip'                            => __('Enable this option if you want to delete plugin tables, roles, files and settings<br>when deleting the plugin from plugins page', 'wpamelia'),
            'appointment_space_name'                           => __('Appointment space name', 'wpamelia'), // Used in Redesign
            'event_space_name'                                 => __('Event space name', 'wpamelia'), // Used in Redesign
            'lesson_space_join'                                => __('Join Space', 'wpamelia'),
            'lesson_space_pending'                             => __('Create spaces for pending appointments', 'wpamelia'), // Used in Redesign  Updated
            'limit_extra_people'                               => __('Limit additional people', 'wpamelia'), // Used in Redesign  Updated
            'limit_extra_people_tooltip'                       => __('Set a maximum number of people a customer can add when booking.', 'wpamelia'), // Used in Redesign  Updated
            'location'                                         => __('Location', 'wpamelia'), // Used in Redesign
            'locations'                                        => __('Locations', 'wpamelia'), // Used in Redesign
            'min'                                              => __('min', 'wpamelia'), // Used in Redesign
            'measurement_id'                                   => __('Measurement ID', 'wpamelia'), // Used in Redesign
            'name'                                             => __('Name', 'wpamelia'), // Used in Redesign
            'enter_name_warning'                               => __('Please enter a name.', 'wpamelia'), // Used in Redesign | Updated
            'name_ascending'                                   => __('Name Asc', 'wpamelia'), // Used in Redesign
            'name_descending'                                  => __('Name Desc', 'wpamelia'), // Used in Redesign
            'need_help'                                        => __('Need help?', 'wpamelia'), // Used in Redesign  Updated
            'no'                                               => __('No', 'wpamelia'), // Used in Redesign  Updated
            'no-show'                                          => __('No-show', 'wpamelia'), // Used in Redesign  Updated
            'note'                                             => __('Note', 'wpamelia'), // Used in Redesign
            'note_internal'                                    => __('Note (internal)', 'wpamelia'), // Used in Redesign
            'notifications'                                    => __('Notifications', 'wpamelia'), // Used in Redesign - duplicate value 'red_notifications'
            'on_site'                                          => __('On-site', 'wpamelia'), // Used in Redesign  Updated
            'opened'                                           => __('Opened', 'wpamelia'),
            'open'                                             => __('Open', 'wpamelia'), // Used in Redesign
            'packages'                                         => __('Packages', 'wpamelia'), // Used in Redesign
            'paid'                                             => __('Paid', 'wpamelia'), // Used in Redesign
            'partially_paid'                                   => __('Partially paid', 'wpamelia'), // Used in Redesign
            'payment'                                          => __('Payment', 'wpamelia'),
            'payment_amount'                                   => __('Payment amount', 'wpamelia'), // Used in Redesign
            'payment_method'                                   => __('Payment method', 'wpamelia'), // Used in Redesign
            'payment_status'                                   => __('Payment status', 'wpamelia'), // Used in Redesign
            'payment_tooltip'                                  => __('If all payment methods are disabled on the service/event, the default payment method will be used.', 'wpamelia'),
            'pdf'                                              => __('PDF', 'wpamelia'),
            'pending'                                          => __('Pending', 'wpamelia'), // Used in Redesign
            'phone'                                            => __('Phone', 'wpamelia'), // Used in Redesign - duplicate value 'phone_colon'
            'rejected'                                         => __('Rejected', 'wpamelia'), // Used in Redesign
            'resources'                                        => __('Resources', 'wpamelia'), // Used in Redesign
            'save'                                             => __('Save', 'wpamelia'), // Used in Redesign
            'select_date_warning'                              => __('Please select a date.', 'wpamelia'), // Used in Redesign  Updated
            'select_time_warning'                              => __('Please select a time.', 'wpamelia'), // Used in Redesign  Updated
            'service'                                          => __('Service', 'wpamelia'), // Used in Redesign
            'services'                                         => __('Services', 'wpamelia'), // Used in Redesign
            'settings_saved'                                   => __('Settings have been saved.', 'wpamelia'), // Used in Redesign  Updated
            'social_login'                                     => __('Social login', 'wpamelia'),
            'status'                                           => __('Status', 'wpamelia'), // Used in Redesign
            'status_colon'                                     => __('Status:', 'wpamelia'),
            'success'                                          => __('Success', 'wpamelia'),
            'text_mode'                                        => __('Text', 'wpamelia'), // Used in Redesign  Updated
            'html_mode'                                        => __('HTML', 'wpamelia'), // Used in Redesign  Updated
            'tag'                                              => __('Tag', 'wpamelia'),
            'to'                                               => __('To', 'wpamelia'), // Used in Redesign  Updated
            'today'                                            => __('Today', 'wpamelia'), // Used in Redesign
            'tomorrow'                                         => __('Tomorrow', 'wpamelia'), // Used in Redesign
            'total'                                            => __('Total', 'wpamelia'), // Used in Redesign
            'translate'                                        => __('Translate', 'wpamelia'), // Used in Redesign
            'waiting'                                          => __('Waiting', 'wpamelia'),
            'weekday_friday'                                   => __('Friday', 'wpamelia'),
            'weekday_monday'                                   => __('Monday', 'wpamelia'), // Used in Redesign
            'weekday_saturday'                                 => __('Saturday', 'wpamelia'), // Used in Redesign
            'weekday_sunday'                                   => __('Sunday', 'wpamelia'), // Used in Redesign
            'weekday_thursday'                                 => __('Thursday', 'wpamelia'),
            'weekday_tuesday'                                  => __('Tuesday', 'wpamelia'),
            'weekday_wednesday'                                => __('Wednesday', 'wpamelia'),
            'yes'                                              => __('Yes', 'wpamelia'), // Used in Redesign
            'zoom'                                             => __('Zoom', 'wpamelia'), // Used in Redesign
            'zoom_click_to_join'                               => __('Join Zoom', 'wpamelia'), // Used in Redesign  Updated
            'zoom_click_to_start'                              => __('Start Zoom', 'wpamelia'), // Used in Redesign  Updated
            'view_grid'                                        => __('Grid view', 'wpamelia'), // Used in Redesign
            'view_list'                                        => __('List view', 'wpamelia'), // Used in Redesign
            'whats_new'                                        => __('What\'s New', 'wpamelia'),
            'layout_select_label'                              => __('Choose layout version', 'wpamelia'),
            'layout_dropdown'                                  => __('Dropdown layout', 'wpamelia'),
            'layout_list'                                      => __('List layout', 'wpamelia'),
            'layout_description'                               => __('Choosing layout of first step in step by step form', 'wpamelia'),
            'xml'                                              => __('XML', 'wpamelia'),
            'recurring'                                        => __('Recurring', 'wpamelia'), // Used in Redesign
            'payment_warning'                                  => __('You have disabled all available payment methods. The default payment method from the general settings will be used instead.', 'wpamelia'), // Used in Redesign | Updated
            'type'                                             => __('Type', 'wpamelia'), // Used in Redesign
            'all_events'                                       => __('All events', 'wpamelia'), // Used in Redesign
            'add'                                              => __('Add', 'wpamelia'), // Used in Redesign
            'integrations'                                     => __('Integrations', 'wpamelia'), // Used in Redesign
            'import'                                           => __('Import', 'wpamelia'), // Used in Redesign
            'all'                                              => __('All', 'wpamelia'), // Used in Redesign
            'from'                                             => __('From', 'wpamelia'),
            'tax'                                              => __('Tax', 'wpamelia'), // Used in Redesign
            'event_tickets'                                    => __('Tickets', 'wpamelia'), // Used in Redesign
            '1year'                                            => __('1 year', 'wpamelia'), // Used in Redesign
            'activate'                                         => __('Activate', 'wpamelia'), // Used in Redesign
            'activation'                                       => __('Activation', 'wpamelia'), // Used in Redesign
            'address'                                          => __('Address', 'wpamelia'), // Used in Redesign
            'after'                                            => __('After', 'wpamelia'), // Used in Redesign
            'after_with_space'                                 => __('After with space', 'wpamelia'),
            'allow_booking_if_pending_tooltip'                 => __('If this is disabled, your front-end customers won\'t be able to book appointment with Pending status above the maximum capacity. Once the maximum capacity is reached appointment will close and time slot will become unavailable.', 'wpamelia'),
            'allow_booking_if_not_min_tooltip'                 => __('If this is disabled, your front-end customers won\'t be able to submit a booking unless they fill in the minimum service capacity, but once they book for any capacity above minimum, the time slot will become unavailable for booking for others. If enabled, multiple customers will be able to book the same time slot, without having to fill in the minimum capacity.', 'wpamelia'),
            'allow_booking_if_not_min'                         => __('Allow booking below minimum capacity', 'wpamelia'),
            'allow_admin_book_at_any_time'                     => __('Allow admin to book appointment at any time', 'wpamelia'),
            'allow_admin_book_over_app'                        => __('Allow admin to book over an existing appointment', 'wpamelia'),
            'allow_admin_book_at_any_time_tooltip'             => __('If you enable this option, Admin will be able to book appointment at any time (working hours, special days and days off for all employees will be ignored).', 'wpamelia'),
            'allow_admin_book_over_app_tooltip'                => __('If you enable this option, Admin will be able to book appointment over or during another appointment.', 'wpamelia'),
            'allow_configure_days_off'                         => __('Allow employees to manage their special days', 'wpamelia'),
            'allow_configure_services'                         => __('Allow employees to manage their services', 'wpamelia'),
            'allow_configure_schedule'                         => __('Allow employees to manage their schedule', 'wpamelia'),
            'allow_configure_special_days'                     => __('Allow employees to manage their days off', 'wpamelia'),
            'allow_booking_if_pending'                         => __('Allow booking above maximum capacity', 'wpamelia'),
            'allow_customer_reschedule'                        => __('Allow customers to reschedule their own appointments', 'wpamelia'),
            'allow_customer_reschedule_tooltip'                => __('Enable this option if you want to allow your customers to reschedule their own appointments.', 'wpamelia'),
            'allow_customer_delete_profile'                    => __('Allow customers to delete their profile', 'wpamelia'),
            'allow_customer_cancel_packages'                   => __('Allow customers to cancel packages', 'wpamelia'),
            'allow_write_appointments'                         => __('Allow employees to manage their appointments', 'wpamelia'),
            'allow_write_events'                               => __('Allow employees to manage their events', 'wpamelia'),
            'allow_write_customers'                            => __('Allow employees to manage customers', 'wpamelia'),
            'api_url'                                          => __('API base URL: ', 'wpamelia'), // Used in Redesign | Updated
            'maximum_capacity'                                 => __('Maximum capacity', 'wpamelia'), // Used in Redesign | Updated
            'waiting_list'                                     => __('Waiting list', 'wpamelia'), // Used in Redesign | Updated
            'events_waiting_list'                              => __('Events waiting list', 'wpamelia'),
            'appointments_waiting_list'                        => __('Appointments waiting list', 'wpamelia'),
            'show_waiting_list_booking_full'                   => __('Show waiting list after booking is full', 'wpamelia'), // Used in Redesign | Updated
            'approve_appointment_success_url'                  => __('Redirect URL for successfully approved booking', 'wpamelia'),
            'approve_appointment_error_url'                    => __('Redirect URL for unsuccessfully approved booking', 'wpamelia'),
            'automatically_create_customer'                    => __('Automatically create Amelia Customer user', 'wpamelia'),
            'automatically_create_customer_tooltip'            => __('If you enable this option every time a new customer schedules the appointment he will get Amelia Customer user role and automatic email with login details.', 'wpamelia'),
            'back_links'                                       => __('Support Amelia by displaying a backlink', 'wpamelia'),  // Used in Redesign | Updated
            'back_links_tooltip'                               => __('Allow the short description below the booking form to support Amelia Booking Plugin and spread the word about it.', 'wpamelia'),
            'bcc_email'                                        => __('Send all notifications to additional addresses', 'wpamelia'),
            'bcc_email_tooltip'                                => __('Here you can enter additional email addresses where all notifications will be sent. To add an address click Enter.', 'wpamelia'),
            'bcc_sms'                                          => __('Send all SMS messages to additional numbers', 'wpamelia'),
            'bcc_sms_tooltip'                                  => __('Here you can enter additional phone numbers where all SMS messages will be sent. To add a number click Enter.', 'wpamelia'),
            'before'                                           => __('Before', 'wpamelia'), // Used in Redesign
            'before_with_space'                                => __('Before with space', 'wpamelia'),
            'bringing_anyone_logic'                            => __('People counting logic', 'wpamelia'),
            'bringing_anyone_logic_additional'                 => __('Customer plus additional people', 'wpamelia'),
            'bringing_anyone_logic_additional_tt'              => __('Counts one primary customer plus any additional people they add.', 'wpamelia'),
            'bringing_anyone_logic_total'                      => __('Total people', 'wpamelia'),
            'bringing_anyone_logic_total_tt'                   => __('Counts the total number of people entered, including the primary customer.', 'wpamelia'),
            'buffer_time_in_slot'                              => __('Include service buffer time in time slots', 'wpamelia'),
            'buffer_time_in_slot_tooltip'                      => __('If this option is enabled time slots will be shown with included service buffer time.', 'wpamelia'),
            'coupons_case_insensitive'                         => __('Set coupons to be case insensitive', 'wpamelia'),
            'calendar'                                         => __('Calendar', 'wpamelia'), // duplicate value 'show_event_view_calendar'
            'cancel_error_url'                                 => __('Unsuccessful cancellation redirect URL', 'wpamelia'),
            'cancel_error_url_tooltip'                         => __('URL on which will user be redirected if appointment can\'t be canceled because of \'Minimum time required before canceling\' value', 'wpamelia'),
            'cancel_success_url'                               => __('Successful cancellation redirect URL', 'wpamelia'),
            'comma_dot'                                        => __('Comma-dot', 'wpamelia'),
            'company'                                          => __('Company', 'wpamelia'), // Used in Redesign
            'country'                                          => __('Country', 'wpamelia'),
            'coupons'                                          => __('Coupons', 'wpamelia'), // Used in Redesign
            'facebook_pixel'                                   => __('Meta Pixel', 'wpamelia'), // Used in Redesign
            'google_analytics'                                 => __('Google Analytics', 'wpamelia'), // Used in Redesign | Updated
            'generate'                                         => __('Generate', 'wpamelia'), // Used in Redesign
            'employee_selection_logic'                         => __('Employee selection logic', 'wpamelia'),
            'employee_selection_logic_random'                  => __('Random', 'wpamelia'),
            'currency'                                         => __('Currency', 'wpamelia'),
            'customers_as_attendees'                           => __('Add event attendees', 'wpamelia'), // Used in Redesign
            'customer_cabinet'                                 => __('Customer Panel Page URL', 'wpamelia'),
            'employee_cabinet'                                 => __('Employee panel page URL', 'wpamelia'),
            'default_appointment_status'                       => __('Default appointment status', 'wpamelia'), // Used in Redesign
            'default_appointment_status_tooltip'               => __('All appointments will be scheduled with the status selected here.', 'wpamelia'), // Used in Redesign | Updated
            'default_items_per_page'                           => __('Default number of items per page on the front end', 'wpamelia'),
            'default_items_per_page_backend'                   => __('Default number of items per page on the back end', 'wpamelia'),
            'default_page_on_backend'                          => __('Default back‑end page', 'wpamelia'), // Used in Redesign | Updated
            'default_payment_method'                           => __('Default payment method', 'wpamelia'),
            'default_phone_country_code'                       => __('Default phone country code', 'wpamelia'), // Used in Redesign | Updated
            'default_time_slot_step'                           => __('Default time slot step', 'wpamelia'),
            'default_time_slot_step_tooltip'                   => __('The time slot step defined here will apply to all time slots across the plugin.', 'wpamelia'),  // Used in Redesign | Updated
            'dot_comma'                                        => __('Dot-comma', 'wpamelia'),
            'see_unavailable_features'                         => __('Hide locked features', 'wpamelia'),
            'envato_api_activate'                              => __('Activate with Envato', 'wpamelia'),
            'event_title_and_description'                      => __('Event title and description', 'wpamelia'), // Used in Redesign
            'mailchimp'                                        => __('Mailchimp', 'wpamelia'),
            'meeting_title'                                    => __('Meeting title', 'wpamelia'), // Used in Redesign
            'meeting_agenda'                                   => __('Meeting agenda', 'wpamelia'), // Used in Redesign
            'facebook_app_id'                                  => __('Facebook app ID', 'wpamelia'), // Used in Redesign
            'facebook_app_secret'                              => __('Facebook app secret', 'wpamelia'), // Used in Redesign
            'general'                                          => __('General', 'wpamelia'), // Used in Redesign
            'gMap_api_key'                                     => __('Google Map API key', 'wpamelia'),
            'gMap_api_key_tooltip'                             => __('Add Google Map API Key to show Google static map on "Locations" page.', 'wpamelia'),
            'google_client_id'                                 => __('Client ID', 'wpamelia'), // Used in Redesign
            'google_client_secret'                             => __('Client secret', 'wpamelia'), // Used in Redesign
            'outlook_client_id'                                => __('Application (client) ID', 'wpamelia'), // Used in Redesign | Updated
            'outlook_client_secret'                            => __('Client secret', 'wpamelia'), // Used in Redesign | Updated
            'google_redirect_uri'                              => __('Redirect URI', 'wpamelia'), // Used in Redesign
            'outlook_redirect_uri'                             => __('Redirect URI', 'wpamelia'), // Used in Redesign
            'apple_client_id'                                  => __('iCloud Email Address', 'wpamelia'),
            'apple_redirect_uri'                               => __('Redirect URI', 'wpamelia'), // Used in Redesign
            'zoom_account_id'                                  => __('Account ID', 'wpamelia'), // Used in Redesign
            'zoom_client_id'                                   => __('Client ID', 'wpamelia'),
            'zoom_client_secret'                               => __('Client secret', 'wpamelia'),
            'lesson_space_api_key'                             => __('Lesson Space API key', 'wpamelia'), // Used in Redesign
            'limit_app_per_customer'                           => __('Limit appointments per customer', 'wpamelia'), // Used in Redesign | Updated
            'limit_package_per_customer'                       => __('Limit package purchases per customer', 'wpamelia'), // Used in Redesign | Updated
            'limit_events_per_customer'                        => __('Limit events per customer', 'wpamelia'),
            'limit_app_per_customer_tt'                        => __('This limit is based on the customer\'s email address.', 'wpamelia'), // Used in Redesign | Updated
            'log_in'                                           => __('Log In', 'wpamelia'),
            'log_out'                                          => __('Log out', 'wpamelia'),
            'invoice_format'                                   => __('Invoice Format', 'wpamelia'),
            'h1'                                               => __('1h', 'wpamelia'),
            'h10'                                              => __('10h', 'wpamelia'),
            'h11'                                              => __('11h', 'wpamelia'),
            'h12'                                              => __('12h', 'wpamelia'),
            'h1min30'                                          => __('1h 30min', 'wpamelia'),
            'h2'                                               => __('2h', 'wpamelia'),
            'h3'                                               => __('3h', 'wpamelia'),
            'h4'                                               => __('4h', 'wpamelia'),
            'h6'                                               => __('6h', 'wpamelia'),
            'h8'                                               => __('8h', 'wpamelia'),
            'h9'                                               => __('9h', 'wpamelia'),
            'identify_country_code'                            => __('Identify country code by user\'s IP address', 'wpamelia'),
            'insert_pending_appointments'                      => __('Insert pending appointments', 'wpamelia'), // Used in Redesign
            'pending_appointments_meetings'                    => __('Create meetings for pending appointments', 'wpamelia'), // Used in Redesign | Updated
            'inspect_customer_info'                            => __('Check customer\'s name for existing email/phone when booking', 'wpamelia'),
            'inspect_customer_info_tooltip'                    => __('Enable this option to ensure that customers using an existing email or phone number maintain consistent first and last names.', 'wpamelia'),
            'mail_service'                                     => __('Mail service', 'wpamelia'),
            'mailgun'                                          => __('Mailgun', 'wpamelia'),
            'manage_languages_tooltip'                         => __('Here you can define languages that you want to have in the plugin for translating dynamic strings (names, descriptions, notifications).', 'wpamelia'),
            'min1'                                             => __('1min', 'wpamelia'),
            'min10'                                            => __('10min', 'wpamelia'),
            'min12'                                            => __('12min', 'wpamelia'),
            'min15'                                            => __('15min', 'wpamelia'),
            'min2'                                             => __('2min', 'wpamelia'),
            'min20'                                            => __('20min', 'wpamelia'),
            'min30'                                            => __('30min', 'wpamelia'),
            'min45'                                            => __('45min', 'wpamelia'),
            'min5'                                             => __('5min', 'wpamelia'),
            'minimum_time_before_booking'                      => __('Minimum time required before booking', 'wpamelia'), // Used in Redesign | Updated
            'minimum_time_before_booking_tooltip'              => __('Define the time before the appointment during which customers can\'t book.', 'wpamelia'), // Used in Redesign | Updated
            'minimum_time_before_canceling'                    => __('Minimum time required before canceling', 'wpamelia'), // Used in Redesign | Updated
            'minimum_time_before_canceling_tooltip'            => __('Define the time before the appointment during which customers can\'t cancel.', 'wpamelia'), // Used in Redesign | Updated
            'minimum_time_before_rescheduling'                 => __('Minimum time required before rescheduling', 'wpamelia'), // Used in Redesign | Updated
            'minimum_time_before_rescheduling_tooltip'         => __('Define the time before the appointment during which customers can\'t reschedule.', 'wpamelia'), // Used in Redesign | Updated
            'notify_customers_default'                         => __('Notify the customer(s) by default', 'wpamelia'),
            'number_of_events_returned'                        => __('Maximum number of events returned', 'wpamelia'),
            'or_enter_details_below'                           => __('Or enter details below', 'wpamelia'),
            'outlook_mail_api'                                 => __('Outlook Mailer', 'wpamelia'), // Used in Redesign
            'payment_links_enable'                             => __('Pay with payment link', 'wpamelia'), // Used in Redesign | Updated
            'payment_links_enable_tooltip'                     => __('If enabled, customers can complete their payment using the link in their email notifications or through the customer panel.', 'wpamelia'), // Used in Redesign | Updated
            'payments'                                         => __('Payments', 'wpamelia'), // Used in Redesign
            'period_available_for_booking'                     => __('Period available for booking in advance', 'wpamelia'), // Used in Redesign | Updated
            'period_available_for_booking_tooltip'             => __('Define how far into the future customers can book appointments.', 'wpamelia'), // Used in Redesign | Updated
            'php_mail'                                         => __('PHP Mail', 'wpamelia'),
            'price_number_of_decimals'                         => __('Price number of decimals', 'wpamelia'),
            'price_separator'                                  => __('Price separator', 'wpamelia'),
            'price_symbol_position'                            => __('Price symbol position', 'wpamelia'),
            'purchase_code'                                    => __('Purchase code', 'wpamelia'), // Used in Redesign | Updated
            'redirect_urls'                                    => __('Redirect URLs', 'wpamelia'),
            'redirect_url_after_appointment'                   => __('Redirect URL after booking', 'wpamelia'), // Used in Redesign
            'redirect_url_after_appointment_tooltip'           => __('Customers will be redirected to this URL after scheduling an appointment.', 'wpamelia'), // Used in Redesign | Updated
            'remove_google_busy_slots'                         => __('Remove Google Calendar busy slots', 'wpamelia'), // Used in Redesign
            'remove_outlook_busy_slots'                        => __('Remove Outlook Calendar busy slots', 'wpamelia'), // Used in Redesign
            'remove_apple_busy_slots'                          => __('Remove Apple Calendar busy slots', 'wpamelia'), // Used in Redesign
            'reject_appointment_success_url'                   => __('Redirect URL for successfully rejected booking', 'wpamelia'),
            'reject_appointment_error_url'                     => __('Redirect URL for unsuccessfully rejected booking', 'wpamelia'),
            'reply_to'                                         => __('Reply-to email', 'wpamelia'),
            'require_cabinet_password'                         => __('Require password for login', 'wpamelia'),
            'send_event_invitation_email'                      => __('Send event invitation email', 'wpamelia'), // Used in Redesign
            'send_invoice_by_default'                          => __('Send invoice to customer by default', 'wpamelia'),
            'send_invoice_by_default_description'              => __('Enable this option to make sure that the invoice will be sent to the customer after booking.', 'wpamelia'),
            'send_ics_attachment_approved'                     => __('Send ICS file for approved bookings', 'wpamelia'),
            'send_ics_attachment_pending'                      => __('Send ICS file for pending bookings', 'wpamelia'),
            'send_ics_attachment_approved_tooltip'             => __('Enable this option if you want to send ics file in email after approved bookings.', 'wpamelia'),
            'send_ics_attachment_pending_tooltip'              => __('Enable this option if you want to send ics file in email after pending bookings.', 'wpamelia'),
            'send_sms_balance_low_email'                       => __('Remind me when my SMS balance is low', 'wpamelia'),
            'send_sms_balance_low_email_tooltip'               => __('Enable this option to receive a reminder email when your SMS balance reaches set minimum', 'wpamelia'),
            'send_sms_balance_low_minimum'                     => __('Credit minimum to send reminder', 'wpamelia'),
            'send_sms_balance_low_to_email'                    => __('Send to e-mail', 'wpamelia'),
            'sender_email'                                     => __('Sender email', 'wpamelia'),
            'sender_email_warning'                             => __('Please enter a sender email.', 'wpamelia'),
            'sender_name'                                      => __('Sender name', 'wpamelia'),
            'sender_name_warning'                              => __('Please enter a sender name.', 'wpamelia'),
            'service_duration_as_slot'                         => __('Use service duration for booking a time slot', 'wpamelia'),
            'service_duration_as_slot_tooltip'                 => __('Enable this option if you want to make time slot step the same as service duration in the booking process', 'wpamelia'),
            'set_ics_description'                              => __('Set ICS file description', 'wpamelia'),
            'set_metaData_and_description'                     => __('Set metadata and description', 'wpamelia'),
            'settings'                                         => __('Settings', 'wpamelia'), // Used in Redesign | Updated
            'show_attendees'                                   => __('Allow customers to see other attendees', 'wpamelia'), // Used in Redesign | Updated
            'show_client_time_zone'                            => __('Show booking slots in client\'s time zone', 'wpamelia'), // Used in Redesign | Updated
            'show_client_time_zone_tooltip'                    => __('Enable to display booking slots based on the client\'s time zone.', 'wpamelia'), // Used in Redesign | Updated
            'smtp'                                             => __('SMTP', 'wpamelia'), // Used in Redesign
            'space_comma'                                      => __('Space-comma', 'wpamelia'),
            'space_dot'                                        => __('Space-dot', 'wpamelia'),
            'stash_entities'                                   => __('Preload entities when page loads', 'wpamelia'),
            'stash_entities_tooltip'                           => __('When enabled, all entities (services, employees, locations, packages, and tags) load as soon as the page opens, instead of being loaded dynamically via AJAX.', 'wpamelia'), // Used in Redesign | Updated
            'square'                                           => __('Square', 'wpamelia'), // Used in Redesign
            'square_disconnected'                              => __('Square account successfully disconnected', 'wpamelia'),
            'square_currency_error'                            => __('The currency in Amelia does not match the currency of your chosen Square location', 'wpamelia'),
            'square_default_location'                          => __('Default Square location', 'wpamelia'),
            'square_login_error'                               => __('Please log in to Square', 'wpamelia'),
            'square_location_error'                            => __('Select your Square Location', 'wpamelia'),
            'square_location_info'                             => __('Locations must be active and have card processing enabled', 'wpamelia'),
            'update_for_all'                                   => __('Update for All', 'wpamelia'), // Used in Redesign | Updated
            'custom_fields_backend_validation'                 => __('Validate required custom fields in the backend', 'wpamelia'), // Used in Redesign | Updated
            'custom_fields_upload_path'                        => __('Attachment upload path', 'wpamelia'), // Used in Redesign | Updated
            'custom_fields_upload_path_tooltip'                => __('If left empty, attachments will be uploaded to the default WordPress uploads folder.', 'wpamelia'),
            'vat_number'                                       => __('VAT number', 'wpamelia'),
            'website'                                          => __('Website', 'wpamelia'),
            'wp_mail'                                          => __('WP Mail', 'wpamelia'),
            'custom_currency_symbol'                           => __('Custom currency symbol', 'wpamelia'),
            'your_api_key'                                     => __('Your API key', 'wpamelia'), // Used in Redesign | Updated
            'admin_time_slot_service_duration'                 => __('Booking time slots will depend on the service duration', 'wpamelia'),
            'admin_time_slot_service_duration_tt'              => __('When this option is deactivated, the booking will be<br/>determined based on the Default Time Slot Step', 'wpamelia'),
            'cart'                                             => __('Cart', 'wpamelia'), // Used in Redesign
            'wc_name'                                          => __('WooCommerce', 'wpamelia'), // Used in Redesign
            'payPal'                                           => __('PayPal', 'wpamelia'), // Used in Redesign
            'stripe'                                           => __('Stripe', 'wpamelia'), // Used in Redesign
            'razorpay'                                         => __('Razorpay', 'wpamelia'), // Used in Redesign
            'barion'                                           => __('Barion', 'wpamelia'),
            'amelia_sms'                                       => __('Amelia SMS', 'wpamelia'), // Used in Redesign
            'balance_colon'                                    => __('Balance', 'wpamelia'),
            'balance_recharged'                                => __('Your balance has been recharged.', 'wpamelia'), // Used in Redesign | Updated
            'carrier'                                          => __('Carrier:', 'wpamelia'),
            'change_password'                                  => __('Change password', 'wpamelia'),
            'cost_colon'                                       => __('Cost:', 'wpamelia'),
            'current_password_colon'                           => __('Current password', 'wpamelia'),
            'current_password_required'                        => __('Please enter current password', 'wpamelia'),
            'customer_appointment_approved'                    => __('Approved', 'wpamelia'), // Used in Redesign | Updated
            'customer_appointment_canceled'                    => __('Canceled', 'wpamelia'), // Used in Redesign | Updated
            'customer_appointment_follow_up'                   => __('Follow up', 'wpamelia'), // Used in Redesign | Updated
            'customer_appointment_next_day_reminder'           => __('Next day reminder', 'wpamelia'), // Used in Redesign | Updated
            'customer_appointment_pending'                     => __('Pending', 'wpamelia'), // Used in Redesign | Updated
            'customer_appointment_rejected'                    => __('Rejected', 'wpamelia'), // Used in Redesign | Updated
            'customer_appointment_rescheduled'                 => __('Rescheduled', 'wpamelia'), // Used in Redesign | Updated
            'customer_account_recovery'                        => __('Panel access', 'wpamelia'), // Used in Redesign | Updated
            'customer_appointment_updated'                     => __('Details changed', 'wpamelia'), // Used in Redesign | Updated
            'customer_birthday_greeting'                       => __('Birthday greeting', 'wpamelia'), // Used in Redesign
            'customer_event_approved'                          => __('Booked', 'wpamelia'), // Used in Redesign | Updated
            'customer_event_canceled'                          => __('Canceled by attendee', 'wpamelia'), // Used in Redesign | Updated
            'customer_event_follow_up'                         => __('Follow up', 'wpamelia'), // Used in Redesign | Updated
            'customer_event_next_day_reminder'                 => __('Next day reminder', 'wpamelia'), // Used in Redesign | Updated
            'customer_event_rejected'                          => __('Canceled by admin', 'wpamelia'), // Used in Redesign | Updated
            'customer_event_rescheduled'                       => __('Rescheduled', 'wpamelia'), // Used in Redesign | Updated
            'customer_event_updated'                           => __('Details changed', 'wpamelia'), // Used in Redesign | Updated
            'customer_event_qr_code'                           => __('Event e-ticket', 'wpamelia'),
            'customer_other_notifications'                     => __('Other', 'wpamelia'), // Used in Redesign
            'customer_event_waiting'                           => __('Waiting list confirmation', 'wpamelia'), // Used in Redesign | Updated
            'customer_appointment_waiting'                     => __('Waiting list confirmation', 'wpamelia'),
            'customer_appointment_waiting_available_spot'      => __('Waiting list availability', 'wpamelia'),
            'customer_cart'                                    => __('Cart purchased', 'wpamelia'), // Used in Redesign | Updated
            'customer_invoice'                                 => __('Booking invoice', 'wpamelia'),
            'customer_package_canceled'                        => __('Package canceled', 'wpamelia'),
            'customer_package_purchased'                       => __('Package purchased', 'wpamelia'),
            'date_colon'                                       => __('Date:', 'wpamelia'),
            'dont_have_an_account'                             => __('Don\'t have an account?', 'wpamelia'),
            'enter_password_warning'                           => __('Please enter a password.', 'wpamelia'), // Used in Redesign | Updated
            'enter_recipient_phone_warning'                    => __('Please enter a recipient phone.', 'wpamelia'), // Used in Redesign | Updated
            'forgot_password'                                  => __('Forgot password?', 'wpamelia'), // Used in Redesign
            'incorrect_email'                                  => __('You have entered an incorrect email.', 'wpamelia'), // Used in Redesign
            'incorrect_password'                               => __('You have entered an incorrect password.', 'wpamelia'), // Used in Redesign
            'logout'                                           => __('Logout', 'wpamelia'),
            'new_password_colon'                               => __('New password', 'wpamelia'),
            'new_password_required'                            => __('Please enter a new password.', 'wpamelia'), // Used in Redesign
            'notification_saved'                               => __('Notification has been saved.', 'wpamelia'), // Used in Redesign | Updated
            'notification_template'                            => __('Notification template', 'wpamelia'), // Used in Redesign
            'payment_history'                                  => __('Payment history', 'wpamelia'),
            'ph_appointment_date'                              => __('Appointment date', 'wpamelia'), // Used in Redesign | Updated
            'ph_appointment_date_time'                         => __('Appointment date & time', 'wpamelia'), // Used in Redesign | Updated
            'ph_appointment_duration'                          => __('Appointment duration', 'wpamelia'), // Used in Redesign | Updated
            'ph_appointment_end_time'                          => __('Appointment end time', 'wpamelia'), // Used in Redesign | Updated
            'ph_appointment_id'                                => __('Appointment ID', 'wpamelia'), // Used in Redesign | Updated
            'ph_payment_due_amount'                            => __('Payment due amount', 'wpamelia'), // Used in Redesign | Updated
            'ph_appointment_notes'                             => __('Appointment notes', 'wpamelia'), // Used in Redesign | Updated
            'ph_appointment_price'                             => __('Appointment price', 'wpamelia'), // Used in Redesign | Updated
            'ph_payment_type'                                  => __('Payment type', 'wpamelia'), // Used in Redesign | Updated
            'ph_appointment_status'                            => __('Appointment status', 'wpamelia'), // Used in Redesign | Updated
            'ph_appointment_start_time'                        => __('Appointment start time', 'wpamelia'), // Used in Redesign | Updated
            'ph_attendee_code'                                 => __('Attendee code', 'wpamelia'), // Used in Redesign | Updated
            'ph_booked_customer'                               => __('Booked customer (full name, email, phone)', 'wpamelia'), // Used in Redesign | Updated
            'ph_booking_number_of_persons'                     => __('Number of people', 'wpamelia'), // Used in Redesign | Updated
            'ph_category_id'                                   => __('Category ID', 'wpamelia'), // Used in Redesign
            'ph_category_name'                                 => __('Category name', 'wpamelia'), // Used in Redesign | Updated
            'ph_company_address'                               => __('Company address', 'wpamelia'), // Used in Redesign | Updated
            'ph_company_name'                                  => __('Company name', 'wpamelia'), // Used in Redesign | Updated
            'ph_company_phone'                                 => __('Company phone', 'wpamelia'), // Used in Redesign | Updated
            'ph_company_website'                               => __('Company website', 'wpamelia'), // Used in Redesign | Updated
            'ph_company_email'                                 => __('Company email', 'wpamelia'), // Used in Redesign | Updated
            'ph_company_vat_number'                            => __('Company VAT number', 'wpamelia'), // Used in Redesign | Updated
            'ph_customer_email'                                => __('Customer email', 'wpamelia'), // Used in Redesign | Updated
            'ph_customer_first_name'                           => __('Customer first name', 'wpamelia'), // Used in Redesign | Updated
            'ph_customer_full_name'                            => __('Customer full name', 'wpamelia'), // Used in Redesign | Updated
            'ph_customer_last_name'                            => __('Customer last name', 'wpamelia'), // Used in Redesign | Updated
            'ph_customer_note'                                 => __('Customer note', 'wpamelia'), // Used in Redesign | Updated
            'ph_customer_phone'                                => __('Customer phone', 'wpamelia'), // Used in Redesign | Updated
            'ph_employee_description'                          => __('Employee description', 'wpamelia'), // Used in Redesign | Updated
            'ph_employee_id'                                   => __('Employee ID', 'wpamelia'), // Used in Redesign | Updated
            'ph_employee_email'                                => __('Employee email', 'wpamelia'), // Used in Redesign | Updated
            'ph_employee_first_name'                           => __('Employee first name', 'wpamelia'), // Used in Redesign | Updated
            'ph_employee_full_name'                            => __('Employee full name', 'wpamelia'), // Used in Redesign | Updated
            'ph_employee_last_name'                            => __('Employee last name', 'wpamelia'), // Used in Redesign | Updated
            'ph_employee_name_email_phone'                     => __('Employee name, email & phone', 'wpamelia'),
            'ph_employee_note'                                 => __('Employee note', 'wpamelia'), // Used in Redesign | Updated
            'ph_employee_phone'                                => __('Employee phone', 'wpamelia'), // Used in Redesign | Updated
            'ph_event_description'                             => __('Event description', 'wpamelia'), // Used in Redesign | Updated
            'ph_event_location'                                => __('Event location', 'wpamelia'), // Used in Redesign
            'ph_event_end_date'                                => __('Event end date', 'wpamelia'), // Used in Redesign | Updated
            'ph_event_end_date_time'                           => __('Event end date & time', 'wpamelia'), // Used in Redesign | Updated
            'ph_event_end_time'                                => __('Event end time', 'wpamelia'), // Used in Redesign | Updated
            'ph_event_id'                                      => __('Event ID', 'wpamelia'), // Used in Redesign | Updated
            'ph_event_name'                                    => __('Event name', 'wpamelia'), // Used in Redesign | Updated
            'ph_event_period_date'                             => __('Event date period', 'wpamelia'), // Used in Redesign | Updated
            'ph_event_period_date_time'                        => __('Event date & time period', 'wpamelia'), // Used in Redesign | Updated
            'ph_event_price'                                   => __('Event price', 'wpamelia'), // Used in Redesign | Updated
            'ph_booking_price'                                 => __('Booking price', 'wpamelia'), // Used in Redesign | Updated
            'ph_event_start_date'                              => __('Event start date', 'wpamelia'), // Used in Redesign | Updated
            'ph_event_start_date_time'                         => __('Event start date & time', 'wpamelia'), // Used in Redesign | Updated
            'ph_event_start_time'                              => __('Event start time', 'wpamelia'), // Used in Redesign | Updated
            'ph_group_event_details'                           => __('Group event details', 'wpamelia'), // Used in Redesign | Updated
            'ph_service_description'                           => __('Service description', 'wpamelia'), // Used in Redesign | Updated
            'ph_service_duration'                              => __('Service duration', 'wpamelia'), // Used in Redesign | Updated
            'ph_service_id'                                    => __('Service ID', 'wpamelia'), // Used in Redesign
            'ph_service_name'                                  => __('Service name', 'wpamelia'), // Used in Redesign | Updated
            'ph_service_price'                                 => __('Service price', 'wpamelia'), // Used in Redesign | Updated
            'ph_time_zone'                                     => __('Time zone', 'wpamelia'), // Used in Redesign | Updated
            'provider_cart'                                    => __('Cart purchased', 'wpamelia'), // Used in Redesign | Updated
            'companyPlaceholders'                              => __('Company', 'wpamelia'),
            'customerPlaceholders'                             => __('Customer', 'wpamelia'),
            'paymentPlaceholders'                              => __('Payment', 'wpamelia'),
            'employeePlaceholders'                             => __('Employee', 'wpamelia'),
            'categoryPlaceholders'                             => __('Category', 'wpamelia'),
            'locationPlaceholders'                             => __('Location', 'wpamelia'),
            'appointmentPlaceholders'                          => __('Appointment', 'wpamelia'),
            'eventPlaceholders'                                => __('Event', 'wpamelia'),
            'extrasPlaceholders'                               => __('Extra', 'wpamelia'),
            'price'                                            => __('Price', 'wpamelia'), // Used in Redesign
            'pricing'                                          => __('Pricing', 'wpamelia'), // Used in Redesign
            'provider_appointment_approved'                    => __('Approved', 'wpamelia'), // Used in Redesign | Updated
            'provider_appointment_canceled'                    => __('Canceled', 'wpamelia'), // Used in Redesign | Updated
            'provider_appointment_next_day_reminder'           => __('Next day reminder', 'wpamelia'), // Used in Redesign | Updated
            'provider_appointment_updated'                     => __('Details changed', 'wpamelia'), // Used in Redesign | Updated
            'provider_package_canceled'                        => __('Package canceled', 'wpamelia'), // Used in Redesign
            'provider_package_purchased'                       => __('Package purchased', 'wpamelia'), // Used in Redesign
            'provider_panel_access'                            => __('Panel access', 'wpamelia'), // Used in Redesign | Updated
            'provider_panel_recovery'                          => __('Panel recovery', 'wpamelia'), // Used in Redesign | Updated
            'provider_appointment_pending'                     => __('Pending', 'wpamelia'), // Used in Redesign | Updated
            'provider_appointment_rejected'                    => __('Rejected', 'wpamelia'), // Used in Redesign | Updated
            'provider_appointment_rescheduled'                 => __('Rescheduled', 'wpamelia'), // Used in Redesign | Updated
            'provider_event_approved'                          => __('Booked', 'wpamelia'), // Used in Redesign | Updated
            'provider_event_canceled'                          => __('Canceled by attendee', 'wpamelia'), // Used in Redesign | Updated
            'provider_event_next_day_reminder'                 => __('Next day reminder', 'wpamelia'), // Used in Redesign | Updated
            'provider_event_rejected'                          => __('Canceled by admin', 'wpamelia'), // Used in Redesign | Updated
            'provider_event_rescheduled'                       => __('Rescheduled', 'wpamelia'), // Used in Redesign | Updated
            'provider_event_updated'                           => __('Details changed', 'wpamelia'), // Used in Redesign | Updated
            'provider_event_waiting'                           => __('Waiting list confirmation', 'wpamelia'), // Used in Redesign | Updated
            'provider_appointment_waiting'                     => __('Waiting list confirmation', 'wpamelia'),
            'provider_appointment_waiting_available_spot'      => __('Waiting list availability', 'wpamelia'),
            'queued'                                           => __('Queued', 'wpamelia'),
            're_type_required'                                 => __('Please enter a new password again.', 'wpamelia'), // Used in Redesign | Updated
            'recharge'                                         => __('Recharge', 'wpamelia'),
            'recharge_balance'                                 => __('Recharge balance', 'wpamelia'), // Used in Redesign
            'recipient_email'                                  => __('Recipient email', 'wpamelia'), // Used in Redesign | Updated
            'requires_scheduling_setup'                        => __('Schedule setup required', 'wpamelia'), // Used in Redesign | Updated
            'segments_colon'                                   => __('Segments', 'wpamelia'),
            'send'                                             => __('Send', 'wpamelia'),
            'send_test_email'                                  => __('Test email', 'wpamelia'), // Used in Redesign | Updated
            'send_test_sms'                                    => __('Test SMS', 'wpamelia'), // Used in Redesign | Updated
            'sender_id_colon'                                  => __('Alpha sender ID', 'wpamelia'),
            'sign_in'                                          => __('Sign in', 'wpamelia'),
            'sign_up'                                          => __('Sign up', 'wpamelia'),
            'sms_history'                                      => __('SMS history', 'wpamelia'), // Used in Redesign
            'sms_vat_apply'                                    => __('If you are in a country where VAT or GST applies, the applicable tax will be added to your transaction.', 'wpamelia'), // Used in Redesign | Updated
            'subject'                                          => __('Subject', 'wpamelia'), // Used in Redesign
            'test_email_error'                                 => __('Failed to send test email.', 'wpamelia'), // Used in Redesign | Updated
            'test_email_success'                               => __('Test email sent successfully.', 'wpamelia'), // Used in Redesign | Updated
            'test_email_warning'                               => __('To send a test email, please configure the \'Sender Email\' in Notification Settings.', 'wpamelia'), // Used in Redesign | Updated
            'test_sms_warning'                                 => __('To send a test SMS, please recharge your balance.', 'wpamelia'), // Used in Redesign | Updated
            'text_colon'                                       => __('Text:', 'wpamelia'),
            'time_colon'                                       => __('Time:', 'wpamelia'),
            'to_customer'                                      => __('To customer', 'wpamelia'), // Used in Redesign
            'to_employee'                                      => __('To employee', 'wpamelia'), // Used in Redesign
            'user_colon'                                       => __('User', 'wpamelia'),
            'user_profile'                                     => __('User profile', 'wpamelia'),
            'view_pricing_for'                                 => __('View pricing for', 'wpamelia'),
            'whatsapp_access_token'                            => __('Permanent access token', 'wpamelia'), // Used in Redesign | Updated
            'whatsapp_auto_reply_enable'                       => __('Enable auto-reply message', 'wpamelia'), // Used in Redesign | Updated
            'whatsapp_auto_reply_notice'                       => __('Messages sent through WhatsApp are without a reply option, so we advise setting the “Auto-reply” message', 'wpamelia'),
            'whatsapp_auto_reply_token'                        => __('WhatsApp webhook verify token', 'wpamelia'), // Used in Redesign | Updated
            'whatsapp_auto_reply_msg'                          => __('WhatsApp auto-reply message', 'wpamelia'), // Used in Redesign | Updated
            'whatsapp_business_id'                             => __('WhatsApp business account ID', 'wpamelia'), // Used in Redesign
            'whatsapp_default_language'                        => __('Default language', 'wpamelia'), // Used in Redesign | Updated
            'whatsapp_phone_id'                                => __('Phone number ID', 'wpamelia'), // Used in Redesign | Updated
            'whatsapp_webhook_url_callback'                    => __('WhatsApp webhook callback URL', 'wpamelia'), // Used in Redesign
            'configure'                                        => __('Configure', 'wpamelia'), // Used in Redesign
            'ph_location_id'                                   => __('Location ID', 'wpamelia'), // Used in Redesign
            'ph_location_latitude'                             => __('Location latitude', 'wpamelia'), // Used in Redesign
            'ph_location_longitude'                            => __('Location longitude', 'wpamelia'), // Used in Redesign
            'password'                                         => __('Password', 'wpamelia'),
            'segment_colon'                                    => __('Segment:', 'wpamelia'),
            'already_have_an_account'                          => __('Already have an account?', 'wpamelia'),
            'email_taken'                                      => __('This email is already in use. Please enter a different email address.', 'wpamelia'), // Used in Redesign | Updated
            'appointments_count'                               => __('# of appointments', 'wpamelia'), // Used in Redesign
            'bookings_revenue'                                 => __('Sum of payments', 'wpamelia'), // Used in Redesign
            'appointments_hours'                               => __('# of Hours in appointment', 'wpamelia'), // Used in Redesign
            'dashboard'                                        => __('Dashboard', 'wpamelia'),
            'new'                                              => __('New', 'wpamelia'), // Used in Redesign
            'pending_appointments'                             => __('Pending appointments', 'wpamelia'), // Used in Redesign
            'percentage_of_load'                               => __('Percentage of Load', 'wpamelia'), // Used in Redesign
            'returning'                                        => __('Returning', 'wpamelia'), // Used in Redesign
            'revenue'                                          => __('Revenue', 'wpamelia'), // Used in Redesign
            'time'                                             => __('Time', 'wpamelia'), // Used in Redesign
            'upcoming_appointments'                            => __('Upcoming appointments', 'wpamelia'), // Used in Redesign | Updated
            'add_day_off'                                      => __('Add day off', 'wpamelia'), // Used in Redesign
            'add_special_day'                                  => __('Add special day', 'wpamelia'), // Used in Redesign
            'apply_to_all_days'                                => __('Apply to all days', 'wpamelia'), // Used in Redesign
            'day_off_name'                                     => __('Day off name', 'wpamelia'), // Used in Redesign | Updated
            'days_off_repeat_yearly'                           => __('Repeat yearly', 'wpamelia'), // Used in Redesign
            'days_off'                                         => __('Days off', 'wpamelia'), // Used in Redesign
            'work_hours'                                       => __('Work hours', 'wpamelia'), // Used in Redesign
            'visibility_hide'                                  => __('Hide', 'wpamelia'), // Used in Redesign
            'visibility_show'                                  => __('Show', 'wpamelia'), // Used in Redesign
            'block'                                            => __('Block', 'wpamelia'), // Used in Redesign
            'unblock'                                          => __('Unblock', 'wpamelia'), // Used in Redesign
            'visible'                                          => __('Visible', 'wpamelia'), // Used in Redesign
            'locations_search_placeholder'                     => __('Search locations', 'wpamelia'), // Used in Redesign | Updated
            'google_maps_notice'                               => __('To enable Google Maps, enter your Google Maps API key in the Google General Settings.', 'wpamelia'), // Used in Redesign | Updated
            'add_category'                                     => __('Add category', 'wpamelia'), // Used in Redesign
            'add_extra'                                        => __('Add Extra', 'wpamelia'), // Used in Redesign
            'categories'                                       => __('Categories', 'wpamelia'),
            'categories_positions_saved'                       => __('Categories positions updated successfully.', 'wpamelia'),
            'category_deleted'                                 => __('Category has been deleted.', 'wpamelia'), // Used in Redesign | Updated
            'confirm_delete_service'                           => __('Are you sure you want to delete this service?', 'wpamelia'), // Used in Redesign
            'confirm_duplicate_service'                        => __('Are you sure you want to duplicate this service?', 'wpamelia'), // Used in Redesign
            'confirm_global_change_service'                    => __('You\'re changing settings that have been individually configured for employees. Do you want to apply these changes to all employees?', 'wpamelia'),
            'confirm_hide_service'                             => __('Are you sure you want to hide this service?', 'wpamelia'),
            'confirm_show_service'                             => __('Are you sure you want to show this service?', 'wpamelia'), // Used in Redesign
            'delete_category_confirmation'                     => __('Are you sure you want to delete this category?', 'wpamelia'), // Used in Redesign | Updated
            'duplicate_category_confirmation'                  => __('Are you sure you want to duplicate this category?', 'wpamelia'), // Used in Redesign
            'duration_and_pricing'                             => __('Pricing & duration ', 'wpamelia'), // Used in Redesign | Updated
            'edit_service'                                     => __('Edit service', 'wpamelia'), // Used in Redesign
            'edit_category'                                    => __('Edit Category', 'wpamelia'), // Used in Redesign
            'gallery'                                          => __('Gallery', 'wpamelia'), // Used in Redesign
            'maximum_capacity_tooltip'                         => __('Set the maximum number of people allowed per appointment for this service.', 'wpamelia'), // Used in Redesign | Updated
            'minimum_capacity'                                 => __('Minimum capacity', 'wpamelia'), // Used in Redesign | Updated
            'minimum_capacity_tooltip'                         => __('Set the minimum number of people required per appointment for this service.', 'wpamelia'),
            'new_category'                                     => __('New category', 'wpamelia'), // Used in Redesign
            'new_service'                                      => __('New service', 'wpamelia'), // Used in Redesign
            'select_service_duration_warning'                  => __('Please select a duration.', 'wpamelia'), // Used in Redesign | Updated
            'select_service_category_warning'                  => __('Please select a category.', 'wpamelia'), // Used in Redesign | Updated
            'service_buffer_time_after'                        => __('Buffer time after', 'wpamelia'), // Used in Redesign
            'service_buffer_time_after_tooltip'                => __('Time needed after the appointment for rest, cleanup, or transition. During this period, the employee cannot be booked for any service.', 'wpamelia'), // Used in Redesign | Updated
            'service_buffer_time_before'                       => __('Buffer time before', 'wpamelia'), // Used in Redesign
            'service_buffer_time_before_tooltip'               => __('Time needed before the appointment for preparation. During this period, the employee cannot be booked for any service.', 'wpamelia'), // Used in Redesign | Updated
            'service_deleted'                                  => __('Service has been deleted.', 'wpamelia'), // Used in Redesign | Updated
            'service_hidden'                                   => __('Service has been hidden.', 'wpamelia'), // Used in Redesign | Updated
            'service_visible'                                  => __('Service is now visible.', 'wpamelia'), // Used in Redesign | Updated
            'services_sorting_price_asc'                       => __('Price Asc', 'wpamelia'), // Used in Redesign | Updated
            'services_sorting_price_desc'                      => __('Price Desc', 'wpamelia'), // Used in Redesign | Updated
            'service_show_on_site'                             => __('Show on website', 'wpamelia'), // Used in Redesign | Updated
            'service_show_on_site_tooltip'                     => __('If this option is disabled, the service will be bookable only from the back end.', 'wpamelia'), // Used in Redesign | Updated
            'service_recurring_cycle'                          => __('Recurring appointments', 'wpamelia'), // Used in Redesign | Updated
            'service_recurring_cycle_tooltip'                  => __("Choose how recurring appointments can be booked. 'Disabled' turns recurring booking off, while 'All' allows customers to choose between available recurrence options.", 'wpamelia'), // Used in Redesign | Updated
            'notify_customer'                                  => __('Notify the customer(s)', 'wpamelia'), // Used in Redesign | Updated
            'service_details'                                  => __('Service details', 'wpamelia'), // Used in Redesign
            'create_new'                                       => __('Create new', 'wpamelia'), // Used in Redesign
            'email'                                            => __('Email', 'wpamelia'), // Used in Redesign - duplicate value 'email_colon'
            'enter_first_name_warning'                         => __('Please enter a first name.', 'wpamelia'), // Used in Redesign | Updated
            'enter_last_name_warning'                          => __('Please enter a last name', 'wpamelia'), // Used in Redesign | Updated
            'first_name'                                       => __('First name', 'wpamelia'), // Used in Redesign
            'last_name'                                        => __('Last name', 'wpamelia'), // Used in Redesign
            'female'                                           => __('Female', 'wpamelia'), // Used in Redesign
            'male'                                             => __('Male', 'wpamelia'), // Used in Redesign
            'notification_language'                            => __('Notification language', 'wpamelia'), // Used in Redesign
            'wp_user'                                          => __('WordPress user', 'wpamelia'), // Used in Redesign
            'wp_user_customer_tooltip'                         => __('Link this customer to a WordPress user so they can log in and view their appointments in Amelia’s back end.', 'wpamelia'), // Used in Redesign | Updated
            'wp_user_employee_tooltip'                         => __('Map a WordPress user to this employee to give them access to view their appointments in the plugin’s back-end.', 'wpamelia'), // Used in Redesign | Updated
            'wp_customer_lang_tooltip'                         => __('Defines the language used for notifications sent to this customer for bookings created from the admin or employee panel. If a supported language was used in a previous booking, it will be automatically selected; otherwise, you can set it manually.', 'wpamelia'), // Used in Redesign | Updated
            'edit_employee'                                    => __('Edit employee', 'wpamelia'), // Used in Redesign
            'employee_show_on_site'                            => __('Show on website', 'wpamelia'),
            'employee_show_on_site_tooltip'                    => __('If this option is disabled, the employee will only be available for booking through the back-end', 'wpamelia'),
            'employee_panel_password'                          => __('Employee panel password', 'wpamelia'), // Used in Redesign
            'special_days'                                     => __('Special days', 'wpamelia'), // Used in Redesign
            'timezone'                                         => __('Time zone', 'wpamelia'), // Used in Redesign | Updated
            'away'                                             => __('Away', 'wpamelia'), // Used in Redesign
            'new_employee'                                     => __('New employee', 'wpamelia'), // Used in Redesign
            'confirm_hide_employee'                            => __('Are you sure you want to hide this employee?', 'wpamelia'),
            'confirm_show_employee'                            => __('Are you sure you want to show this employee?', 'wpamelia'), // Used in Redesign
            'employee_visible'                                 => __('Employee is now visible.', 'wpamelia'), // Used in Redesign | Updated
            'employee_hidden'                                  => __('Employee has been hidden.', 'wpamelia'), // Used in Redesign | Updated
            'confirm_delete_employee'                          => __('Are you sure you want to delete this employee?', 'wpamelia'), // Used in Redesign
            'confirm_delete_customer'                          => __('Are you sure you want to delete this customer?', 'wpamelia'), // Used in Redesign
            'confirm_block_customer'                           => __('Are you sure you want to block this customer?', 'wpamelia'), // Used in Redesign
            'confirm_unblock_customer'                         => __('Are you sure you want to unblock this customer?', 'wpamelia'), // Used in Redesign
            'customer_deleted'                                 => __('Customer has been deleted.', 'wpamelia'), // Used in Redesign | Updated
            'customer_blocked'                                 => __('Customer has been blocked.', 'wpamelia'), // Used in Redesign | Updated
            'customer_phone'                                   => __('Customer phone', 'wpamelia'), // Used in Redesign
            'customer_unblocked'                               => __('Customer has been unblocked.', 'wpamelia'), // Used in Redesign | Updated
            'customer_note'                                    => __('Note', 'wpamelia'),
            'customers'                                        => __('Customers', 'wpamelia'),
            'customers_search_placeholder'                     => __('Search customers', 'wpamelia'), // Used in Redesign | Updated
            'date_of_birth'                                    => __('Date of birth', 'wpamelia'), // Used in Redesign
            'edit_customer'                                    => __('Edit customer', 'wpamelia'), // Used in Redesign
            'gender'                                           => __('Gender', 'wpamelia'), // Used in Redesign
            'imported_customers'                               => __('Customers imported from file:', 'wpamelia'), // Used in Redesign | Updated
            'last_booking'                                     => __('Last booking', 'wpamelia'), // Used in Redesign
            'new_customer'                                     => __('New customer', 'wpamelia'), // Used in Redesign
            'required_data'                                    => __('Required fields: <b>First Name</b> and <b>Last Name</b>.', 'wpamelia'), // Used in Redesign | Updated
            'total_appointments'                               => __('Total appointments', 'wpamelia'), // Used in Redesign
            'total_bookings'                                   => __('Total bookings', 'wpamelia'), // Used in Redesign
            'total_events'                                     => __('Total events', 'wpamelia'), // Used in Redesign
            'view_appointments'                                => __('View appointments', 'wpamelia'), // Used in Redesign
            'view_events'                                      => __('View events', 'wpamelia'), // Used in Redesign
            'drag_drop'                                        => __('Drop files here or click to upload', 'wpamelia'), // Used in Redesign | Updated
            'import_rules'                                     => __('Import Rules', 'wpamelia'), // Used in Redesign | Updated
            'import_successful'                                => __('Import successful', 'wpamelia'), // Used in Redesign | Updated
            'map_data'                                         => __('Please map corresponding data to columns:', 'wpamelia'), // Used in Redesign | Updated
            'wrong_format'                                     => __('Some records have an incorrect format.', 'wpamelia'), // Used in Redesign | Updated
            'amount'                                           => __('Amount', 'wpamelia'), // Used in Redesign
            'booking_start'                                    => __('Booking start', 'wpamelia'), // Used in Redesign
            'customer_email'                                   => __('Customer email', 'wpamelia'), // Used in Redesign
            'employee_email'                                   => __('Employee email', 'wpamelia'), // Used in Redesign
            'method'                                           => __('Method', 'wpamelia'),  // Used in Redesign
            'payment_date'                                     => __('Payment date', 'wpamelia'), // Used in Redesign | Updated
            'payment_created'                                  => __('Payment created', 'wpamelia'), // Used in Redesign | Updated
            'rate'                                             => __('Rate', 'wpamelia'), // Used in Redesign
            'invoice_qty'                                      => __('Qty', 'wpamelia'),
            'invoice_total_item_price'                         => __('Total price', 'wpamelia'),
            'invoices'                                         => __('Invoices', 'wpamelia'), // Used in Redesign
            'discount_amount'                                  => __('Discount', 'wpamelia'), // Used in Redesign
            'due'                                              => __('Due', 'wpamelia'), // Used in Redesign
            'finance'                                          => __('Finance', 'wpamelia'), // Used in Redesign
            'payment_details'                                  => __('Payment details', 'wpamelia'), // Used in Redesign
            'service_price'                                    => __('Service price', 'wpamelia'), // Used in Redesign
            'subtotal'                                         => __('Subtotal', 'wpamelia'), // Used in Redesign
            'total_price'                                      => __('Total price', 'wpamelia'), // Used in Redesign
            'event_price'                                      => __('Event price', 'wpamelia'), // Used in Redesign
            'appointment_deleted'                              => __('Appointment has been deleted.', 'wpamelia'), // Used in Redesign | Updated
            'appointment_rescheduled'                          => __('Appointment has been rescheduled', 'wpamelia'),
            'appointment_status_changed'                       => __('Appointment status has been changed to ', 'wpamelia'),
            'category'                                         => __('Category', 'wpamelia'), // Used in Redesign
            'confirm_delete_appointment'                       => __('Are you sure? This action can\'t be undone.', 'wpamelia'), // Used in Redesign | Updated
            'confirm_duplicate_appointment'                    => __('Are you sure you want to duplicate this appointment?', 'wpamelia'), // Used in Redesign
            'custom_fields'                                    => __('Custom fields', 'wpamelia'), // Used in Redesign - title case
            'edit_appointment'                                 => __('Edit appointment', 'wpamelia'), // Used in Redesign
            'end_time'                                         => __('End time', 'wpamelia'), // Used in Redesign
            'new_appointment'                                  => __('New appointment', 'wpamelia'), // Used in Redesign
            'notify_attendees'                                 => __('Notify the attendees', 'wpamelia'), // Used in Redesign | Updated
            'notify_attendees_tooltip'                         => __('Notify attendees by email when event information is updated.', 'wpamelia'),  // Used in Redesign | Updated
            'over_booking_message'                             => __('By continuing, you will set the appointment to a time slot that already has an existing appointment!', 'wpamelia'),
            'select_service_warning'                           => __('Please select a service.', 'wpamelia'), // Used in Redesign | Updated
            'start_time'                                       => __('Start time', 'wpamelia'), // Used in Redesign
            'booking_reschedule_exception'                     => __('Appointment can\'t be rescheduled', 'wpamelia'),
            'booking_status_changed'                           => __('Booking status has been changed to ', 'wpamelia'),
            'wc'                                               => __('WooCommerce', 'wpamelia'),
            'select_a_customer_warning'                        => __('Please select a customer.', 'wpamelia'), // Used in Redesign | Updated
            'select_employee_warning'                          => __('Please select an employee.', 'wpamelia'), // Used in Redesign | Updated
            'deposit_enabled'                                  => __('Deposit payment', 'wpamelia'), // Used in Redesign
            'custom_pricing'                                   => __('Custom pricing', 'wpamelia'), // Used in Redesign
            'custom_duration_pricing_enabled'                  => __('Pricing by duration', 'wpamelia'), // Used in Redesign | Updated
            'custom_person_pricing_enabled'                    => __('Pricing by number of people', 'wpamelia'), // Used in Redesign | Updated
            'custom_period_pricing_enabled'                    => __('Pricing by date & time', 'wpamelia'), // Used in Redesign | Updated
            'recurring_appointments'                           => __('Recurring appointments', 'wpamelia'),
            'confirm_duplicate_event'                          => __('Are you sure you want to duplicate this event?', 'wpamelia'),
            'confirm_cancel'                                   => __('Are you sure you want to cancel this event?', 'wpamelia'), // Used in Redesign
            'confirm_open'                                     => __('Are you sure you want to open this event?', 'wpamelia'), // Used in Redesign
            'event_cancel_before_delete'                       => __('Please cancel the event first before deleting it.', 'wpamelia'),
            'customize'                                        => __('Customize', 'wpamelia'),
            'full'                                             => __('Full', 'wpamelia'),
            'upcoming'                                         => __('Upcoming', 'wpamelia'),
            'edit_event'                                       => __('Edit event', 'wpamelia'),
            'event_book_persons'                               => __('Number of people', 'wpamelia'),
            'event_book_status'                                => __('Status', 'wpamelia'),
            'event_book_tickets'                               => __('Number of Tickets', 'wpamelia'), // Used in Redesign | Updated
            'event_aggregated_price'                           => __('Multiply price by number of people', 'wpamelia'), // Used in Redesign | Updated
            'event_book_more_than_once'                        => __('Allow multiple bookings per customer', 'wpamelia'), // Used in Redesign | Updated
            'event_bringing_anyone'                            => __('Allow additional people', 'wpamelia'), // Used in Redesign | Updated
            'event_cancel'                                     => __('Cancel Event', 'wpamelia'), // Used in Redesign
            'event_close_after_min'                            => __('Close event when minimum capacity is reached', 'wpamelia'), // Used in Redesign | Updated
            'event_close_min_total'                            => __('Minimum number of attendees', 'wpamelia'), // Used in Redesign | Updated
            'event_close_min_bookings'                         => __('Minimum number of bookings', 'wpamelia'), // Used in Redesign | Updated
            'event_close_min_total_tt'                         => __('Each spot counts as one attendee.', 'wpamelia'), // Used in Redesign | Updated
            'event_close_min_bookings_tt'                      => __('A single booking may include multiple attendees (spots).', 'wpamelia'), // Used in Redesign | Updated
            'event_close_minimum'                              => __('Set minimum', 'wpamelia'), // Used in Redesign
            'event_custom_address'                             => __('Custom address', 'wpamelia'), // Used in Redesign
            'event_delete'                                     => __('Delete Event', 'wpamelia'), // Used in Redesign
            'event_deleted'                                    => __('Event has been deleted.', 'wpamelia'), // Used in Redesign | Updated
            'event_booking_closes_on'                          => __('Closes on', 'wpamelia'), // Used in Redesign | Updated
            'event_booking_opens_on'                           => __('Opens on', 'wpamelia'), // Used in Redesign | Updated
            'event_booking_closes_after'                       => __('Booking closes when event starts', 'wpamelia'), // Used in Redesign | Updated
            'event_booking_opens_now'                          => __('Booking opens immediately', 'wpamelia'), // Used in Redesign | Updated
            'event_open'                                       => __('Open Event', 'wpamelia'), // Used in Redesign
            'event_opened'                                     => __('Event has been opened.', 'wpamelia'), // Used in Redesign | Updated
            'event_canceled'                                   => __('Event has been canceled.', 'wpamelia'), // Used in Redesign | Updated
            'event_search_placeholder'                         => __('Search events', 'wpamelia'), // Used in Redesign | Updated
            'event_staff'                                      => __('Staff', 'wpamelia'), // Used in Redesign
            'event_organizer'                                  => __('Organizer', 'wpamelia'), // Used in Redesign
            'event_organizer_tooltip'                          => __('Select the employee who will be added as the organizer of the Google/Outlook/Apple Calendar event. Employees selected under Staff will be added as guests.', 'wpamelia'), // Used in Redesign | Updated
            'event_tags'                                       => __('Tags', 'wpamelia'), // Used in Redesign
            'event_show_on_site'                               => __('Show on website', 'wpamelia'),  // Used in Redesign | Updated
            'event_status_changed'                             => __('Booking status has been changed to ', 'wpamelia'),
            'new_event'                                        => __('New event', 'wpamelia'),
            'maximum_capacity_reached'                         => __('Maximum capacity is reached', 'wpamelia'),
            'confirm'                                          => __('Confirm', 'wpamelia'), // Used in Redesign
            'add_custom_field'                                 => __('Add custom field', 'wpamelia'), // Used in Redesign
            'are_you_sure_reset_customize'                     => __('Are you sure you want to reset your form settings?', 'wpamelia'),
            'current_changes_will_be_lost'                     => __('Your current changes will be lost.', 'wpamelia'),
            'reset_yes'                                        => __('Yes, Reset', 'wpamelia'),
            'reset_no'                                         => __('No, Cancel', 'wpamelia'),
            'reset_form'                                       => __('Reset Form', 'wpamelia'),
            'package_available'                                => __('Available in package', 'wpamelia'),
            'bringing_anyone_with_you'                         => __('Bringing anyone with you?', 'wpamelia'),
            'buttons'                                          => __('Buttons', 'wpamelia'),
            'package_discount_text'                            => __('Save', 'wpamelia'),
            'default_label'                                    => __('Default Label', 'wpamelia'),
            'duration_colon'                                   => __('Duration', 'wpamelia'),
            'checkbox'                                         => __('Checkbox', 'wpamelia'), // Used in Redesign
            'click_add_custom_field'                           => __('Start by clicking the add custom field button', 'wpamelia'),
            'text_content'                                     => __('Text content', 'wpamelia'), // Used in Redesign
            'custom_fields_title'                              => __('Custom Fields', 'wpamelia'), // Used in Redesign
            'font'                                             => __('Font', 'wpamelia'),
            'no_custom_fields_yet'                             => __('You don\'t have any custom fields here yet...', 'wpamelia'),
            'options'                                          => __('Options:', 'wpamelia'), // Used in Redesign | Updated
            'pick_date_and_time'                               => __('Pick date & time', 'wpamelia'),
            'please_select_service'                            => __('Please select service', 'wpamelia'),
            'primary'                                          => __('Primary', 'wpamelia'),
            'primary_color'                                    => __('Primary color', 'wpamelia'),
            'success_color'                                    => __('Success', 'wpamelia'),
            'warning_color'                                    => __('Warning', 'wpamelia'),
            'error_color'                                      => __('Error', 'wpamelia'),
            'radio'                                            => __('Radio button', 'wpamelia'), // Used in Redesign | Updated
            'reset'                                            => __('Reset', 'wpamelia'),
            'select'                                           => __('Select Box', 'wpamelia'),
            'steps'                                            => __('Steps', 'wpamelia'),
            'select_service'                                   => __('Select service', 'wpamelia'),
            'text'                                             => __('Text', 'wpamelia'), // Used in Redesign
            'text-area'                                        => __('Text area', 'wpamelia'), // Used in Redesign
            'text_color'                                       => __('Text color', 'wpamelia'),
            'placeholder_color'                                => __('Placeholder Color', 'wpamelia'),
            'text_color_on_background'                         => __('Text color on background', 'wpamelia'),
            'file'                                             => __('Attachment', 'wpamelia'), // Used in Redesign
            'datepicker'                                       => __('Date picker', 'wpamelia'), // Used in Redesign
            'preview'                                          => __('Preview', 'wpamelia'),
            'bgr_color'                                        => __('Background Color', 'wpamelia'),
            'bgr_gradient_color1'                              => __('Background Gradient Color 1', 'wpamelia'),
            'bgr_gradient_color2'                              => __('Background Gradient Color 2', 'wpamelia'),
            'bgr_gradient_angle'                               => __('Background Gradient Angle', 'wpamelia'),
            'input_color'                                      => __('Input Color', 'wpamelia'),
            'input_text_color'                                 => __('Input Text Color', 'wpamelia'),
            'dropdown_color'                                   => __('Dropdown Color', 'wpamelia'),
            'dropdown_text_color'                              => __('Dropdown Text Color', 'wpamelia'),
            'image_color'                                      => __('Image Color', 'wpamelia'),
            'recurring_active'                                 => __('Repeat this appointment', 'wpamelia'),
            'first_name_colon'                                 => __('First name', 'wpamelia'),
            'last_name_colon'                                  => __('Last name', 'wpamelia'),
            'last_name_input_field'                            => __('Last name', 'wpamelia'),
            'email_colon'                                      => __('Email', 'wpamelia'),
            'email_input_field'                                => __('Email', 'wpamelia'),
            'phone_colon'                                      => __('Phone', 'wpamelia'),
            'phone_input_field'                                => __('Phone', 'wpamelia'),
            'go_back'                                          => __('Go back', 'wpamelia'),
            'service_name'                                     => __('Service name', 'wpamelia'),
            'display_field'                                    => __('Display Field:', 'wpamelia'),
            'filterable_field'                                 => __('Filterable Field:', 'wpamelia'),
            'mandatory_field'                                  => __('Mandatory Field:', 'wpamelia'),
            'event_type'                                       => __('Event type', 'wpamelia'),
            'event_location'                                   => __('Event location', 'wpamelia'),
            'event_free'                                       => __('Free', 'wpamelia'),
            'service_badge'                                    => __('Service badge', 'wpamelia'),
            'package_name'                                     => __('Package name', 'wpamelia'),
            'congratulations'                                  => __('Congratulations!', 'wpamelia'),
            'add_to_calendar'                                  => __('Add to calendar', 'wpamelia'), // Used in Redesign
            'finish_appointment'                               => __('Finish', 'wpamelia'),
            'form_type_step_by_step'                           => __('Step By Step Booking Form', 'wpamelia'),
            'event_status'                                     => __('Event status', 'wpamelia'),
            'event_filters'                                    => __('Filters', 'wpamelia'),
            'event_book_event'                                 => __('Book event', 'wpamelia'), // Used in Redesign | Updated
            'form_block_service'                               => __('Service', 'wpamelia'),
            'form'                                             => __('Form', 'wpamelia'),
            'form_flow'                                        => __('Form Flow', 'wpamelia'),
            'use_global_colors'                                => __('Use Global Colors', 'wpamelia'),
            'service_selection'                                => __('Service selection', 'wpamelia'),
            'employee_selection'                               => __('Employee selection', 'wpamelia'),
            'location_selection'                               => __('Location selection', 'wpamelia'),
            'service_colon'                                    => __('Service', 'wpamelia'),
            'dropdown_category_heading'                        => __('Category', 'wpamelia'),
            'dropdown_items_heading'                           => __('Service', 'wpamelia'),
            'dropdown_empty'                                   => __('No matching data', 'wpamelia'),
            'bringing_anyone'                                  => __('Bringing anyone with you', 'wpamelia'),
            'show_more'                                        => __('Show more', 'wpamelia'),
            'show_less'                                        => __('Show less', 'wpamelia'), // Used in Redesign | Updated
            'date_time'                                        => __('Date & time', 'wpamelia'), // Used in Redesign
            'date_time_slots_selected'                         => __('All slots are selected', 'wpamelia'),
            'info_step'                                        => __('Your information', 'wpamelia'),
            'enter_first_name'                                 => __('Enter first name', 'wpamelia'),
            'enter_last_name'                                  => __('Enter last name', 'wpamelia'),
            'enter_email'                                      => __('Enter email', 'wpamelia'),
            'enter_phone'                                      => __('Enter phone', 'wpamelia'),
            'enter_phone_warning'                              => __('Please enter phone', 'wpamelia'),
            'payment_step'                                     => __('Payment', 'wpamelia'),
            'summary'                                          => __('Summary', 'wpamelia'), // Used in Redesign
            'summary_services'                                 => __('Services', 'wpamelia'),
            'summary_services_subtotal'                        => __('Service subtotal', 'wpamelia'),
            'summary_persons'                                  => __('people', 'wpamelia'),
            'total_amount_colon'                               => __('Total amount', 'wpamelia'),
            'payment_onsite_sentence'                          => __('The payment will be done on-site.', 'wpamelia'),
            'appointment_id'                                   => __('Appointment ID', 'wpamelia'),
            'congrats_total_amount'                            => __('Total amount', 'wpamelia'),
            'congrats_payment'                                 => __('Payment', 'wpamelia'),
            'your_name_colon'                                  => __('Your name', 'wpamelia'),
            'email_address_colon'                              => __('Email address', 'wpamelia'),
            'phone_number_colon'                               => __('Phone number', 'wpamelia'), // Used in Redesign
            'congrats_date'                                    => __('Date', 'wpamelia'),
            'congrats_time'                                    => __('Local time', 'wpamelia'),
            'congrats_service'                                 => __('Service', 'wpamelia'),
            'congrats_employee'                                => __('Employee', 'wpamelia'),
            'congrats_location'                                => __('Location', 'wpamelia'),
            'choose_form'                                      => __('Choose a Form', 'wpamelia'),
            'choose_form_for_customize'                        => __('Choose a form you want to customize. The Step-by-Step 2.0 form is the new and improved version which provides you with better design and user experience, as well as better speed.', 'wpamelia'),
            'sbs_booking_form'                                 => __('Step-by-step', 'wpamelia'), // Used in Redesign | Updated
            'sbs_booking_form_old'                             => __('Booking Forms 1.0', 'wpamelia'),
            'redesigned_sbs_booking_form'                      => __('Provide a simplified, guided booking experience on your website. Customize the design and labels to improve usability and align with your business needs.', 'wpamelia'), // Used in Redesign | Updated
            'old_forms_text'                                   => __('The original booking forms—Step-by-Step, Catalog, Event List, and Event Calendar—feature basic customization and label changes, serving as the foundation for our newer versions.', 'wpamelia'),
            'primary_and_state_colors'                         => __('Primary and state colors', 'wpamelia'),
            'sidebar'                                          => __('Sidebar area', 'wpamelia'),
            'background_color'                                 => __('Background Color', 'wpamelia'),
            'content'                                          => __('Content', 'wpamelia'),
            'heading_text_color'                               => __('Heading Text Color', 'wpamelia'),
            'content_text_color'                               => __('Content Text Color', 'wpamelia'),
            'input_fields'                                     => __('Input fields', 'wpamelia'),
            'border_color'                                     => __('Border color', 'wpamelia'),
            'dropdowns'                                        => __('Dropdowns', 'wpamelia'),
            'lower_price_background'                           => __('Lower price background', 'wpamelia'),
            'higher_price_background'                          => __('Higher price background', 'wpamelia'),
            'lower_price_text'                                 => __('Lower price text', 'wpamelia'),
            'higher_price_text'                                => __('Higher price text', 'wpamelia'),
            'waiting_list_background'                          => __('Waiting list background', 'wpamelia'),
            'waiting_list_text'                                => __('Waiting list text', 'wpamelia'),
            'primary_text'                                     => __('Primary text', 'wpamelia'),
            'secondary_color'                                  => __('Secondary color', 'wpamelia'),
            'danger_background'                                => __('Danger button background color', 'wpamelia'),
            'danger_text'                                      => __('Danger button text color', 'wpamelia'),
            'layout_and_inputs'                                => __('Layout & Inputs', 'wpamelia'),
            'colors'                                           => __('Colors', 'wpamelia'),
            'fonts'                                            => __('Fonts', 'wpamelia'),
            'order'                                            => __('Order', 'wpamelia'),
            'step_title'                                       => __('Title section', 'wpamelia'),
            'footer_buttons'                                   => __('Footer buttons', 'wpamelia'),
            'step_content'                                     => __('Step content', 'wpamelia'),
            'finish_btn_type'                                  => __('Finish Button Type', 'wpamelia'),
            'panel_btn_type'                                   => __('Panel Button Type', 'wpamelia'),
            'summary_segment'                                  => __('Summary segment', 'wpamelia'),
            'payment_segment'                                  => __('Payment segment', 'wpamelia'),
            'heading_title'                                    => __('Heading title', 'wpamelia'),
            'sub_steps'                                        => __('Sub Steps', 'wpamelia'),
            'step_popups'                                      => __('Step Popups', 'wpamelia'),
            'csb_global_settings_content'                      => __('Fonts and colors', 'wpamelia'),
            'csb_sidebar_content'                              => __('Set up Sidebar visibility and its content', 'wpamelia'),
            'csb_packages'                                     => __('Packages popup', 'wpamelia'),
            'csb_services_content'                             => __('Set up Services, Locations, Employees selection options', 'wpamelia'),
            'csb_services_only_content'                        => __('Set up Services selection options', 'wpamelia'),
            'csb_employees_only_content'                       => __('Set up Employees selection options', 'wpamelia'),
            'csb_locations_only_content'                       => __('Set up Locations selection options', 'wpamelia'),
            'csb_date_time_content'                            => __('Set up Calendar layout and Recurring popup options', 'wpamelia'),
            'csb_info_step'                                    => __('Customer information', 'wpamelia'),
            'csb_info_step_content'                            => __('Field order, mandatory fields, labels and display options', 'wpamelia'),
            'csb_payment'                                      => __('Payment summary', 'wpamelia'),
            'csb_payment_content'                              => __('Set up labels and buttons', 'wpamelia'),
            'cpb_congratulations_content'                      => __('Set up button types and labels', 'wpamelia'),
            'plus_more'                                        => __('+more', 'wpamelia'),
            'cb_global_settings_heading'                       => __('Global Settings', 'wpamelia'),
            'cb_sidebar'                                       => __('Sidebar area', 'wpamelia'),
            'cb_section'                                       => __('Section', 'wpamelia'),
            'cb_field_order_heading'                           => __('Field Order', 'wpamelia'),
            'cb_congratulations_heading'                       => __('Congratulations', 'wpamelia'),
            'sidebar_footer'                                   => __('Footer', 'wpamelia'),
            'get_in_touch'                                     => __('Get in touch', 'wpamelia'),
            'collapse_menu'                                    => __('Collapse menu', 'wpamelia'),
            'sb_radio_filled'                                  => __('Filled', 'wpamelia'),
            'sb_radio_plain'                                   => __('Plain', 'wpamelia'),
            'sb_radio_text'                                    => __('Text', 'wpamelia'),
            'continue_button_type'                             => __('\'Continue\' button style', 'wpamelia'),
            'calendar_slot_end_time'                           => __('Slot end time', 'wpamelia'),
            'show_busy_slots'                                  => __('Busy slots', 'wpamelia'),
            'show_estimated_pricing'                           => __('Estimated price', 'wpamelia'),
            'show_slot_pricing'                                => __('Time slot price', 'wpamelia'),
            'show_indicator_pricing'                           => __('Price indicators', 'wpamelia'),
            'show_people_waiting'                              => __('Number of people on waiting list', 'wpamelia'),
            'calendar_time_zone'                               => __('Time zone', 'wpamelia'),
            'finish_button_type'                               => __('\'Finish\' button style', 'wpamelia'),
            'panel_button_type'                                => __('\'Customer panel\' button style', 'wpamelia'),
            'sidebar_visibility'                               => __('Sidebar visibility', 'wpamelia'),
            'publish_form'                                     => __('Publish Form', 'wpamelia'),
            'view_all'                                         => __('View all', 'wpamelia'),
            'csb_categories'                                   => __('Categories', 'wpamelia'),
            'csb_categories_content'                           => __('Set up categories cards', 'wpamelia'),
            'cards'                                            => __('Cards', 'wpamelia'),
            'card_button_type'                                 => __('Button style', 'wpamelia'),
            'csb_category_services'                            => __('Services overview', 'wpamelia'),
            'csb_category_services_content'                    => __('Set up Services view', 'wpamelia'),
            'csb_category_service'                             => __('Service details', 'wpamelia'),
            'csb_category_service_content'                     => __('Set up Service detailed view', 'wpamelia'),
            'booking_form'                                     => __('Booking Form', 'wpamelia'),
            'booking_form_content'                             => __('Set options, colors and labels for booking form', 'wpamelia'),
            'cat_booking_form'                                 => __('Catalog', 'wpamelia'), // Used in Redesign | Updated
            'redesigned_cat_booking_form'                      => __('Showcase your services in stylish card layouts. Easily organize them by category and tailor the appearance to match your brand.', 'wpamelia'), // Used in Redesign | Updated
            'card_services_number'                             => __('Service count', 'wpamelia'),
            'back_btn_heading'                                 => __('Back button', 'wpamelia'),
            'back_btn_type'                                    => __('\'Back\' button style', 'wpamelia'),
            'back_btn'                                         => __('Go back', 'wpamelia'),
            'booking_btn_type'                                 => __('\'Book now\' button style', 'wpamelia'),
            'cl_btn'                                           => __('Main category button', 'wpamelia'),
            'cl_side_color'                                    => __('Ribbon', 'wpamelia'),
            'cl_color'                                         => __('Color', 'wpamelia'),
            'cil_filter_menu_btn'                              => __('\'Filter\' button style', 'wpamelia'),
            'cil_sidebar'                                      => __('Categories sidebar', 'wpamelia'),
            'cil_filter_block'                                 => __('Filters block', 'wpamelia'),
            'cil_side_menu_block'                              => __('Categories sidebar', 'wpamelia'),
            'cil_main_header'                                  => __('Page header', 'wpamelia'),
            'cil_main_content'                                 => __('Main content', 'wpamelia'),
            'service_category'                                 => __('Service category', 'wpamelia'),
            'service_duration'                                 => __('Service duration', 'wpamelia'),
            'service_about'                                    => __('About service', 'wpamelia'),
            'cil_filter_input'                                 => __('Search', 'wpamelia'),
            'cli_item_color'                                   => __('Card color', 'wpamelia'),
            'page_scroll_visibility'                           => __('Page scroll', 'wpamelia'),
            'filter_input'                                     => __('Search', 'wpamelia'),
            'available'                                        => __('Available', 'wpamelia'), // Used in Redesign
            'heading_service'                                  => __('Service', 'wpamelia'),
            'heading_services'                                 => __('Services', 'wpamelia'),
            'no_search_data'                                   => __('No results', 'wpamelia'), // Used in Redesign | Updated
            'free'                                             => __('Free', 'wpamelia'),
            'book_now'                                         => __('Book now', 'wpamelia'),
            'about_service'                                    => __('About service', 'wpamelia'),
            'view_all_photos'                                  => __('View all photos', 'wpamelia'),
            'contact_message'                                  => __('Contact message', 'wpamelia'),
            'company_phone'                                    => __('Company Phone:', 'wpamelia'),
            'company_email'                                    => __('Company Email:', 'wpamelia'),
            'elf_booking_form'                                 => __('Events list', 'wpamelia'), // Used in Redesign | Updated
            'redesigned_elf_booking_form'                      => __('Offer a clean, list-based booking experience with a design that grabs attention. Customers can easily explore and book from your full event lineup.', 'wpamelia'), // Used in Redesign | Updated
            'csb_events_list'                                  => __('Events list', 'wpamelia'),
            'csb_events_list_content'                          => __('Set up Location, Images, Filters, Capacity, Price, and Status visibility options', 'wpamelia'),
            'csb_event_info'                                   => __('Event info', 'wpamelia'),
            'csb_event_info_content'                           => __('Set up staff, location, gallery and other event information visibility', 'wpamelia'),
            'csb_event_customer'                               => __('Customer information', 'wpamelia'),
            'csb_event_customer_content'                       => __('Field order, mandatory fields, labels and display options', 'wpamelia'),
            'csb_event_payment'                                => __('Payment', 'wpamelia'),
            'csb_event_payment_content'                        => __('Set up labels and buttons', 'wpamelia'),
            'csb_event_congratulations'                        => __('Congratulations', 'wpamelia'),
            'csb_event_congratulations_content'                => __('Set up button types and labels', 'wpamelia'),
            'events_available'                                 => __('Events available', 'wpamelia'),
            'event_available'                                  => __('Event available', 'wpamelia'),
            'event_page'                                       => __('Page', 'wpamelia'),
            'event_search'                                     => __('Search for events', 'wpamelia'),
            'event_begins'                                     => __('Begins', 'wpamelia'),
            'event_slot_left'                                  => __('slot left', 'wpamelia'),
            'event_slots_left'                                 => __('slots left', 'wpamelia'),
            'event_learn_more'                                 => __('Learn more', 'wpamelia'),
            'event_read_more'                                  => __('Read more', 'wpamelia'),
            'event_close'                                      => __('Close', 'wpamelia'),
            'event_customer_info'                              => __('Your information', 'wpamelia'),
            'summary_event'                                    => __('Event', 'wpamelia'),
            'event_id'                                         => __('Event ID', 'wpamelia'),
            'about'                                            => __('About', 'wpamelia'),
            'event_info'                                       => __('Event info', 'wpamelia'),
            'event_timetable'                                  => __('Timetable', 'wpamelia'),
            'event_payment'                                    => __('Payment', 'wpamelia'),
            'event_congrats'                                   => __('Congratulations', 'wpamelia'),
            'event_about_list'                                 => __('About event', 'wpamelia'),
            'event_start'                                      => __('Event starts', 'wpamelia'),
            'event_end'                                        => __('Event ends', 'wpamelia'),
            'event_at'                                         => __('at', 'wpamelia'),
            'event_bringing'                                   => __('How many attendees do you want to book event for?', 'wpamelia'),
            'step_filters'                                     => __('Filter', 'wpamelia'),
            'event_card'                                       => __('Event card', 'wpamelia'),
            'step_pagination'                                  => __('Step pagination', 'wpamelia'),
            'event_slots_capacity'                             => __('Event slots capacity', 'wpamelia'),
            'filters_button_type'                              => __('\'Filter\' button style', 'wpamelia'),
            'read_more_button_type'                            => __('\'Read more\' button style', 'wpamelia'),
            'learn_more_button_type'                           => __('\'Learn more\' button style', 'wpamelia'),
            'event_tab_img'                                    => __('Image', 'wpamelia'),
            'step_header'                                      => __('Step header', 'wpamelia'),
            'step_info_tab'                                    => __('Step info tab', 'wpamelia'),
            'booking_event_btn'                                => __('\'Book\' button style', 'wpamelia'),
            'finish_event_btn'                                 => __('\'Finish\' button style', 'wpamelia'),
            'close_event_btn'                                  => __('\'Close\' button style', 'wpamelia'),
            'event_gallery'                                    => __('Event gallery', 'wpamelia'),
            'event_description'                                => __('Event description', 'wpamelia'), // Used in Redesign
            'summary_person'                                   => __('person', 'wpamelia'),
            'event_employees'                                  => __('Event employees', 'wpamelia'),
            'learn_more'                                       => __('Learn more', 'wpamelia'),
            'service_information'                              => __('Service information', 'wpamelia'),
            'learn_more_button'                                => __('\'Learn more\' button', 'wpamelia'),
            'location_address'                                 => __('Location address', 'wpamelia'),
            'no_results_found'                                 => __('No results found...', 'wpamelia'),
            'card_field'                                       => __('Card field', 'wpamelia'),
            'popup_content'                                    => __('Description', 'wpamelia'),
            'layout'                                           => __('Layout', 'wpamelia'),
            'search_input_field'                               => __('Search Input Field', 'wpamelia'),
            'category_input_field'                             => __('Category Input Field', 'wpamelia'),
            'select_service_category'                          => __('Select Service Category', 'wpamelia'),
            'visibility'                                       => __('Visibility', 'wpamelia'), // Used in Redesign
            'bringing_people_total'                            => __('Total people', 'wpamelia'), // Used in Redesign | Updated
            'attendees'                                        => __('Attendees', 'wpamelia'),
            'event_upcoming_events'                            => __('Upcoming events', 'wpamelia'), // Used in Redesign
            'book_appointment'                                 => __('Book appointment', 'wpamelia'), // Used in Redesign
            'custom'                                           => __('Custom', 'wpamelia'), // Used in Redesign
            'ecf_booking_form'                                 => __('Events calendar', 'wpamelia'), // Used in Redesign | Updated
            'redesigned_ecf_booking_form'                      => __('Display events in a calendar view, allowing customers to browse, search, and book directly. A great way to highlight upcoming events in an interactive format.', 'wpamelia'),
            'capc_form'                                        => __('Customer panel', 'wpamelia'), // Used in Redesign | Updated
            'redesigned_capc_form'                             => __('Enable customers to manage their appointments and events efficiently. Personalize colors and labels to create a seamless and branded experience.', 'wpamelia'), // Used in Redesign | Updated
            'cape_form'                                        => __('Employee panel', 'wpamelia'), // Used in Redesign | Updated
            'redesigned_cape_form'                             => __('Allow employees to manage appointments and events with ease. Customize colors to match your branding and improve usability.', 'wpamelia'), // Used in Redesign | Updated
            'new_password_colon_retype'                        => __('Re-type new password', 'wpamelia'),
            'catalog'                                          => __('Catalog', 'wpamelia'),
            'choose_category'                                  => __('Choose Category', 'wpamelia'),
            'choose_service'                                   => __('Choose Service', 'wpamelia'),
            'choose_package'                                   => __('Choose Package', 'wpamelia'),
            'filter'                                           => __('Preselect Booking Parameters', 'wpamelia'), // Used in Redesign
            'skip_categories'                                  => __('Skip Categories step', 'wpamelia'),
            'insert_amelia_shortcode'                          => __('Insert Amelia Booking Shortcode', 'wpamelia'),
            'select_catalog_view'                              => __('Select Catalog View', 'wpamelia'),
            'select_category'                                  => __('Select category', 'wpamelia'),
            'select_employee'                                  => __('Select employee', 'wpamelia'),
            'select_location'                                  => __('Select location', 'wpamelia'),
            'select_package'                                   => __('Select Package', 'wpamelia'),
            'select_event'                                     => __('Select Event', 'wpamelia'),
            'select_events'                                    => __('Select Events', 'wpamelia'),
            'select_tag'                                       => __('Select Tag', 'wpamelia'),
            'select_tags'                                      => __('Select Tags', 'wpamelia'),
            'select_view'                                      => __('Select View', 'wpamelia'),
            'show'                                             => __('Show', 'wpamelia'),
            'show_all'                                         => __('Show All', 'wpamelia'),
            'manually_loading'                                 => __('Load booking form manually', 'wpamelia'),
            'manually_loading_description'                     => __('Add element (button, link...) ID, that will manually load amelia shortcode content', 'wpamelia'),
            'multiselect_note'                                 => __('For multiselect: hold CTRL / Command (⌘).', 'wpamelia'),
            'show_all_categories'                              => __('Show all categories', 'wpamelia'),
            'show_all_employees'                               => __('Show all employees', 'wpamelia'),
            'show_all_locations'                               => __('Show all locations', 'wpamelia'),
            'show_all_services'                                => __('Show all services', 'wpamelia'), // Used in Redesign | Updated
            'show_all_events'                                  => __('Show all events', 'wpamelia'),
            'show_all_packages'                                => __('Show all packages', 'wpamelia'),
            'show_all_tags'                                    => __('Show all tags', 'wpamelia'),
            'show_catalog'                                     => __('Show catalog of all categories', 'wpamelia'),
            'show_category'                                    => __('Show specific category', 'wpamelia'),
            'show_categories'                                  => __('Show specific categories', 'wpamelia'),
            'show_package'                                     => __('Show specific package', 'wpamelia'),
            'show_packages'                                    => __('Show specific packages', 'wpamelia'),
            'show_event'                                       => __('Show event', 'wpamelia'),
            'show_event_view_type'                             => __('Show Type', 'wpamelia'),
            'show_event_view_list'                             => __('List (default)', 'wpamelia'),
            'show_event_view_calendar'                         => __('Calendar', 'wpamelia'),
            'show_tag'                                         => __('Show tag', 'wpamelia'),
            'show_service'                                     => __('Show specific service', 'wpamelia'),
            'show_services'                                    => __('Show specific services', 'wpamelia'),
            'trigger_type'                                     => __('Trigger type', 'wpamelia'),
            'trigger_type_id'                                  => __('Id', 'wpamelia'),
            'trigger_type_class'                               => __('Class', 'wpamelia'),
            'trigger_type_tooltip'                             => __('Trigger by attribute', 'wpamelia'),
            'step_booking'                                     => __('Step Booking', 'wpamelia'),
            'catalog_booking'                                  => __('Catalog Booking', 'wpamelia'),
            'events_list_booking'                              => __('Events List Booking', 'wpamelia'),
            'recurring_event'                                  => __('Show recurring events', 'wpamelia'),
            'in_dialog'                                        => __('Show in Amelia Popup', 'wpamelia'),
            'booking_divi'                                     => __('AM - Booking view', 'wpamelia'),
            'step_booking_divi'                                => __('AM - Step Booking', 'wpamelia'),
            'catalog_booking_divi'                             => __('AM - Catalog Booking', 'wpamelia'),
            'catalog_divi'                                     => __('AM - Catalog view', 'wpamelia'),
            'events_divi'                                      => __('AM - Events view', 'wpamelia'),
            'events_list_booking_divi'                         => __('AM - Events List Booking', 'wpamelia'),
            'events_calendar_booking_divi'                     => __('AM - Events Calendar Booking', 'wpamelia'),
            'booking_gutenberg_block'                          => [
                'title'       => __('Amelia - Booking view', 'wpamelia'),
                'description' => __('Step-By-Step Booking Wizard gives your customers the option to choose everything about the booking in a few steps', 'wpamelia'),
            ],
            'step_booking_gutenberg_block'                     => [
                'title'       => __('Amelia - Step-By-Step Booking', 'wpamelia'),
                'description' => __('Step-by-Step booking view guides the customers through several steps in order to make their bookings.', 'wpamelia'),
            ],
            'catalog_booking_gutenberg_block'                  => [
                'title'       => __('Amelia - Catalog Booking', 'wpamelia'),
                'description' => __('Front-end Booking Catalog is shortcode when you want to show your service in a form of a catalog', 'wpamelia'),
            ],
            'catalog_gutenberg_block'                          => [
                'title'       => __('Amelia - Catalog view', 'wpamelia'),
                'description' => __('Front-end Booking Catalog is shortcode when you want to show your service in a form of a cataloge', 'wpamelia'),
            ],
            'events_gutenberg_block'                           => [
                'title'       => __('Amelia - Events', 'wpamelia'),
                'description' => __('Event Booking is shortcode that gives your customers the option to book one of the events that you\'ve created on the back-end in a simple event list view.', 'wpamelia'),
            ],
            'events_list_booking_gutenberg_block'              => [
                'title'       => __('Amelia - Events List', 'wpamelia'),
                'description' => __('Event Booking is shortcode that gives your customers the option to book one of the events that you\'ve created on the back-end in a simple event list view.', 'wpamelia'),
            ],
            'events_calendar_booking_gutenberg_block'          => [
                'title'       => __('Amelia - Events Calendar', 'wpamelia'),
                'description' => __('Event Booking is shortcode that gives your customers the option to book one of the events that you\'ve created on the back-end in a simple event calendar view.', 'wpamelia'),
            ],
            'outdated_booking_gutenberg_block'                 => __('You are using a form that will be outdated soon!', 'wpamelia'),
            'search'                                           => __('Search', 'wpamelia'), // Used in Redesign
            'red_activation_settings'                          => __('Activation settings', 'wpamelia'),
            'red_action_triggered'                             => __('Action Triggered', 'wpamelia'),
            'red_add_custom_notification'                      => __('Add custom notification', 'wpamelia'),
            'red_add_work_hours'                               => __('Add work hours', 'wpamelia'),
            'red_agencies'                                     => __('Agencies', 'wpamelia'),
            'red_api'                                          => __('API', 'wpamelia'),
            'red_appointment_created_success'                  => __('Appointment has been created.', 'wpamelia'),
            'red_appointment_status_updated'                   => __('Appointment status has been updated.'),
            'red_appointment_details'                          => __('Appointment details', 'wpamelia'),
            'red_appointment_note_updated'                     => __('Appointment note has been updated.', 'wpamelia'),
            'red_are_you_sure_delete_items'                    => __('Are you sure you want to delete these items?', 'wpamelia'),
            'red_at_time'                                      => __('at {time}', 'wpamelia'),
            'red_attendee_asc'                                 => __('Attendee Asc', 'wpamelia'),
            'red_attendee_desc'                                => __('Attendee Desc', 'wpamelia'),
            'red_beauty'                                       => __('Beauty', 'wpamelia'),
            'red_blog'                                         => __('Blog', 'wpamelia'),
            'red_book'                                         => __('Book', 'wpamelia'),
            'red_booking_closes_asc'                           => __('Booking Closes Asc', 'wpamelia'),
            'red_booking_closes_desc'                          => __('Booking Closes Desc', 'wpamelia'),
            'red_booking_closes'                               => __('Booking closes', 'wpamelia'),
            'red_booking_number_count'                         => __('Booking #{count}', 'wpamelia'),
            'red_booking_opens_asc'                            => __('Booking Opens Asc', 'wpamelia'),
            'red_booking_opens_desc'                           => __('Booking Opens Desc', 'wpamelia'),
            'red_booking_opens'                                => __('Booking opens', 'wpamelia'),
            'red_booking_type'                                 => __('Booking type', 'wpamelia'),
            'red_bookings_count'                               => __('# of bookings', 'wpamelia'),
            'red_buddyboss'                                    => __('BuddyBoss', 'wpamelia'),
            'red_cancel_and_delete'                            => __('Cancel and Delete', 'wpamelia'),
            'red_configure_combined_placeholder_tooltip'       => __('Click "Configure" to edit the text that will appear when this placeholder is used in notifications.', 'wpamelia'),
            'red_content_placeholders'                         => __('Content placeholders', 'wpamelia'),
            'red_catalog'                                      => __('Catalog', 'wpamelia'),
            'red_clear_filters'                                => __('Clear filters', 'wpamelia'),
            'red_clear'                                        => __('Clear', 'wpamelia'),
            'red_click_to_upload'                              => __('Click to upload', 'wpamelia'),
            'red_coaching'                                     => __('Coaching', 'wpamelia'),
            'red_color'                                        => __('Color', 'wpamelia'),
            'red_compared_stats'                               => __('Compared to previous range', 'wpamelia'),
            'red_consulting'                                   => __('Consulting', 'wpamelia'),
            'red_contact_support'                              => __('Contact support.', 'wpamelia'),
            'red_count_attendees'                              => __('{count} Attendee | {count} Attendees', 'wpamelia'),
            'red_count_days'                                   => __('{count} day | {count} days', 'wpamelia'),
            'red_count_hours'                                  => __('{count} hour | {count} hours', 'wpamelia'),
            'red_count_minutes'                                => __('{count} minute | {count} minutes', 'wpamelia'),
            'red_count_months'                                 => __('{count} month | {count} months', 'wpamelia'),
            'red_count_selected'                               => __('{count} Selected', 'wpamelia'),
            'red_count_weeks'                                  => __('{count} week | {count} weeks', 'wpamelia'),
            'red_custom_notifications'                         => __('Custom notifications', 'wpamelia'),
            'red_customer_configuration'                       => __('Customer configuration', 'wpamelia'),
            'red_customer_asc'                                 => __('Customer Asc', 'wpamelia'),
            'red_customer_desc'                                => __('Customer Desc', 'wpamelia'),
            'red_customer_note'                                => __('Customer note', 'wpamelia'),
            'red_customers_detected_in_file'                   => __('Customers detected in file:', 'wpamelia'),
            'red_daily_occupancy'                              => __('Daily occupancy', 'wpamelia'),
            'red_enter_phone_number_then_press_enter_to_add'   => __('Enter a phone number, then press Enter to add', 'wpamelia'),
            'red_dark_theme'                                   => __('Dark Theme', 'wpamelia'),
            'red_date_asc'                                     => __('Date Asc', 'wpamelia'),
            'red_date_desc'                                    => __('Date Desc', 'wpamelia'),
            'red_delete_appointment'                           => __('Delete appointment', 'wpamelia'),
            'red_delete_booking'                               => __('Delete booking', 'wpamelia'),
            'red_delete_service_effect_past'                   => __('This service has {count} appointment in the past. | This service has {count} appointments in the past.', 'wpamelia'),
            'red_documentation'                                => __('Documentation', 'wpamelia'),
            'red_duplicate_appointment'                        => __('Duplicate appointment', 'wpamelia'),
            'red_duration_asc'                                 => __('Duration Asc', 'wpamelia'),
            'red_duration_desc'                                => __('Duration Desc', 'wpamelia'),
            'red_e_ticket_qr_code'                             => __('E-ticket QR code', 'wpamelia'),
            'red_edit_booking'                                 => __('Edit booking', 'wpamelia'),
            'red_edit_event'                                   => __('Edit event', 'wpamelia'),
            'red_edit_table_subtitle'                          => __('Drag to rearrange columns and/or choose which ones to display.', 'wpamelia'),
            'red_edit_transaction'                             => __('Edit transaction', 'wpamelia'),
            'red_edit_table'                                   => __('Edit table', 'wpamelia'),
            'red_enable'                                       => __('Enable', 'wpamelia'),
            'red_end_date'                                     => __('End date', 'wpamelia'),
            'red_event_asc'                                    => __('Event Asc', 'wpamelia'),
            'red_event_booking_details'                        => __('Event Booking Details', 'wpamelia'),
            'red_event_desc'                                   => __('Event Desc', 'wpamelia'),
            'red_event_details'                                => __('Event details', 'wpamelia'),
            'red_export_bookings'                              => __('Export bookings', 'wpamelia'),
            'red_facebook_social_login_description'            => __('Allow customers and employees to quickly sign in using their Facebook account, making the login process faster, simpler, and more secure.', 'wpamelia'),
            'red_facebook_social_login'                        => __('Facebook social login', 'wpamelia'),
            'red_feature_api_description'                      => __('Connect APIs effortlessly for smooth, integrated workflows.', 'wpamelia'),
            'red_feature_apple_calendar_description'           => __('Connect Apple Calendars to sync your personal and professional events, along with your employees’.', 'wpamelia'),
            'red_feature_barion_description'                   => __('Simple, secure payments powered by Barion.', 'wpamelia'),
            'red_feature_buddyboss_description'                => __('Display Amelia booking forms and panels on BuddyBoss member profiles.', 'wpamelia'),
            'red_feature_cart_description'                     => __('Allow customers to book multiple services in a single transaction for a streamlined experience.', 'wpamelia'),
            'red_feature_coupons_description'                  => __('Offer discounts or free appointments with customizable coupons.', 'wpamelia'),
            'red_feature_custom_duration_description'          => __('Offer services with multiple duration options for customers to choose from.', 'wpamelia'),
            'red_feature_custom_fields_description'            => __('Use custom fields as intake forms to collect customer information during booking.', 'wpamelia'),
            'red_feature_custom_notifications_description'     => __('Send personalized email and SMS notifications tailored to your business.', 'wpamelia'),
            'red_feature_custom_pricing_description'           => __('Set dynamic pricing for services based on various conditions.', 'wpamelia'),
            'red_feature_deposit_payment_description'          => __('Allow clients to secure bookings with partial payments.', 'wpamelia'),
            'red_feature_e_ticket_qr_code_description'         => __('Enable quick, contactless event check-ins with unique QR codes for each ticket.', 'wpamelia'),
            'red_feature_employee_badge_description'           => __('Enhance bookings with customizable badges to strengthen your brand identity.', 'wpamelia'),
            'red_feature_event_tickets_description'            => __('Set flexible ticket pricing with categories and date-based ranges to maximize accessibility and revenue.', 'wpamelia'),
            'red_feature_extras_description'                   => __('Offer upsells or additional benefits within a service using extras.', 'wpamelia'),
            'red_feature_facebook_pixel_description'           => __('Add Meta Pixel to track ad conversions and optimize marketing.', 'wpamelia'),
            'red_feature_google_analytics_description'         => __('Add a Google Analytics tracking code to your booking page to gain insights into visitor behavior.', 'wpamelia'),
            'red_feature_google_calendar_description'          => __('Connect Google Calendars to sync your personal and professional events, along with your employees’.', 'wpamelia'),
            'red_feature_google_disconnect'                    => __('Disconnect account', 'wpamelia'),
            'red_feature_google_general_description'           => __('Sync your and your employees\' personal and professional events by connecting Google calendars.', 'wpamelia'),
            'red_feature_google_sign_in_button'                => __('Sign in with Google', 'wpamelia'),
            'red_feature_invoices_description'                 => __('Generate invoices automatically for bookings to streamline payments and improve client experience.', 'wpamelia'),
            'red_feature_lesson_space_description'             => __('Create online classrooms automatically for each booked appointment or event.', 'wpamelia'),
            'red_feature_mailchimop_description'               => __('Send your customer data to Mailchimp quickly and effortlessly.', 'wpamelia'),
            'red_feature_mollie_description'                   => __('Accept payments seamlessly through the Mollie payment gateway.', 'wpamelia'),
            'red_feature_no_show_tag_description'              => __('Track customers who miss appointments or events without sending notifications.', 'wpamelia'),
            'red_feature_outlook_calendar_description'         => __('Connect Outlook Calendars to sync your personal and professional events, along with your employees’.', 'wpamelia'),
            'red_feature_packages_description'                 => __('Bundle multiple appointments or services at discounted rates to encourage customers to book more.', 'wpamelia'),
            'red_feature_paypal_description'                   => __('Accept payments for bookings and services via PayPal.', 'wpamelia'),
            'red_feature_razorpay_description'                 => __('Accept payments via Razorpay, ideal for Indian businesses.', 'wpamelia'),
            'red_feature_recaptcha_description'                => __('Protect your booking system from bots by integrating reCAPTCHA keys.', 'wpamelia'),
            'red_feature_recurring_appointments_description'   => __('Allow customers to book repeating appointments with customizable recurrence.', 'wpamelia'),
            'red_feature_resources_description'                => __('Create resources like rooms or chairs that can be shared across services, locations, and employees.', 'wpamelia'),
            'red_feature_square_description'                   => __('Process payments easily with Square.', 'wpamelia'),
            'red_feature_stripe_description'                   => __('Securely process payments using Stripe.', 'wpamelia'),
            'red_feature_tax_description'                      => __('Automatically calculate and apply taxes for hassle-free compliance and accurate billing.', 'wpamelia'),
            'red_feature_time_zones_description'               => __('Set individual time zones for employees so availability and bookings are shown correctly for clients worldwide.', 'wpamelia'),
            'red_feature_event_waiting_list_description'       => __('Manage event cancellations efficiently by allowing customers to join waiting lists and filling open spots manually.', 'wpamelia'),
            'red_feature_appointment_waiting_list_description' => __('Efficiently manage appointment cancellations by allowing customers to join a waiting list and manually fill newly opened time slots.', 'wpamelia'),
            'red_feature_webhooks_description'                 => __('Connect with web apps to automate messaging and send updates to custom URLs.', 'wpamelia'),
            'red_feature_whatsapp_description'                 => __('Send appointment notifications directly via WhatsApp.', 'wpamelia'),
            'red_feature_woocommerce_description'              => __('Integrate with WooCommerce to enable advanced e-commerce capabilities.', 'wpamelia'),
            'red_feature_zoom_description'                     => __('Automatically create Zoom meetings for bookings and notify customers and employees.', 'wpamelia'),
            'red_features_integrations'                        => __('Features & Integrations', 'wpamelia'),
            'red_features'                                     => __('Features', 'wpamelia'),
            'red_fri'                                          => __('Fri', 'wpamelia'),
            'red_full_events'                                  => __('Full events', 'wpamelia'),
            'red_go_to_custom_fields'                          => __('Go to Custom Fields', 'wpamelia'),
            'red_google_calendar_and_google_meet'              => __('Google Calendar & Google Meet', 'wpamelia'),
            'red_google_meet'                                  => __('Google Meet', 'wpamelia'),
            'red_google_social_login_description'              => __('Allow customers and employees to quickly sign in using their Google account, making the login process faster, simpler, and more secure.', 'wpamelia'),
            'red_google_social_login'                          => __('Google social login', 'wpamelia'),
            'red_gyms'                                         => __('Gyms', 'wpamelia'),
            'red_healthcare'                                   => __('Healthcare', 'wpamelia'),
            'red_hidden'                                       => __('Hidden', 'wpamelia'),
            'red_hour_short'                                   => __('h', 'wpamelia'),
            'red_id_asc'                                       => __('ID Asc', 'wpamelia'),
            'red_id_desc'                                      => __('ID Desc', 'wpamelia'),
            'red_import_rules_1'                               => __('You can import the following columns: First name, Last name, Email, Phone, Gender, Birthday, Note.', 'wpamelia'),
            'red_industries'                                   => __('Industries', 'wpamelia'),
            'red_import_rules_2'                               => __('The first row should not contain column names.', 'wpamelia'),
            'red_import_rules_3'                               => __('Valid first and last names are required fields.', 'wpamelia'),
            'red_import_rules_4'                               => __('First and last names must be in two separate fields.', 'wpamelia'),
            'red_import_rules_5'                               => __('Date of birth must be in the same format as chosen in your WP settings. If a date format with a comma is used, the dates should be in quotes.', 'wpamelia'),
            'red_import_rules_6'                               => __('Phone number must include a country code.', 'wpamelia'),
            'red_import_rules_7'                               => __('Gender should be specified as either \'male\' or \'female\'.', 'wpamelia'),
            'red_import_rules_8'                               => __('If multiple customers have the same email address, only the first one will be imported.', 'wpamelia'),
            'red_import_rules_9'                               => __('If invalid, other values will be skipped and not imported.', 'wpamelia'),
            'red_last_booking_asc'                             => __('Last Booking Asc', 'wpamelia'),
            'red_last_booking_desc'                            => __('Last Booking Desc', 'wpamelia'),
            'red_less_options'                                 => __('Less options', 'wpamelia'),
            'red_light_theme'                                  => __('Light Theme', 'wpamelia'),
            'red_manage_bookings'                              => __('Manage bookings', 'wpamelia'),
            'red_max_capacity_asc'                             => __('Max Capacity Asc', 'wpamelia'),
            'red_max_capacity_desc'                            => __('Max Capacity Desc', 'wpamelia'),
            'red_microsoft_teams'                              => __('Microsoft Teams', 'wpamelia'),
            'red_message'                                      => __('Message', 'wpamelia'),
            'red_message_content'                              => __('Message content', 'wpamelia'),
            'red_message_template'                             => __('Message template', 'wpamelia'),
            'red_minute_short'                                 => __('min', 'wpamelia'),
            'red_mon'                                          => __('Mon', 'wpamelia'),
            'red_more_features_zero_limits'                    => __('More Features Zero Limits', 'wpamelia'),
            'red_more_options'                                 => __('More options', 'wpamelia'),
            'red_need_additional_fields'                       => __('Need additional fields?', 'wpamelia'),
            'red_new_attendee'                                 => __('New Attendee', 'wpamelia'),
            'red_new_event_booking'                            => __('New event booking', 'wpamelia'),
            'red_new_update'                                   => __('New Update', 'wpamelia'),
            'red_no_appointments_subtitle_1'                   => __('Once you receive bookings, your appointments will be displayed here. You can also get started by clicking the Add button below.', 'wpamelia'),
            'red_no_appointments_yet'                          => __('No appointments yet', 'wpamelia'),
            'red_no_attendees_found'                           => __('No attendees found', 'wpamelia'),
            'red_no_event_bookings_subtitle_1'                 => __('Once you receive event bookings, they will be displayed here. You can also get started by clicking the Book Event button below.', 'wpamelia'),
            'red_no_event_bookings_yet'                        => __('No event bookings yet', 'wpamelia'),
            'red_no_events_subtitle_1'                         => __('Once you add your first event, it will appear here. Click + Event below to get started.', 'wpamelia'),
            'red_no_events_yet'                                => __('No events yet', 'wpamelia'),
            'red_no_results_found_empty'                       => __('No results found', 'wpamelia'),
            'red_no_results_found'                             => __('No results found', 'wpamelia'),
            'red_no_results_found_for'                         => __('No results found for', 'wpamelia'),
            'red_no_search_results_subtitle'                   => __('Try adjusting your search or filters.', 'wpamelia'),
            'red_no_services_or_employees_available_subtitle'  => __('Please ensure that services and employees are created and that services are assigned to employees.', 'wpamelia'),
            'red_no_services_or_employees_available'           => __('No services or employees available', 'wpamelia'),
            'red_no_services_subtitle_1_part_1'                => __('Once you add your first service, it will appear here.', 'wpamelia'),
            'red_no_services_subtitle_1_part_2'                => __('Click + Service below to get started.', 'wpamelia'),
            'red_no_services_subtitle_2_part_1'                => __('Try adjusting your filters or search criteria to find the services you\'re looking for.', 'wpamelia'),
            'red_no_services_subtitle_2_part_2'                => __('You can also clear all filters to view all services.', 'wpamelia'),
            'red_no_services_yet'                              => __('No services yet', 'wpamelia'),
            'red_no_show_1'                                    => __('No Show (1)', 'wpamelia'),
            'red_no_show_2'                                    => __('No Show (2)', 'wpamelia'),
            'red_no_show_3_plus'                               => __('No Show (3+)', 'wpamelia'),
            'red_no_show_tag'                                  => __('No-show tag', 'wpamelia'),
            'red_no_top_trends'                                => __('No top trends', 'wpamelia'),
            'red_no_transactions_subtitle_1'                   => __('Once you start receiving bookings, transactions will be displayed here.', 'wpamelia'),
            'red_no_transactions_title'                        => __('No transactions yet', 'wpamelia'),
            'red_no_upcoming_events_subtitle'                  => __('There are no future events scheduled. Please create a new event.', 'wpamelia'),
            'red_no_upcoming_events'                           => __('No upcoming events', 'wpamelia'),
            'red_no_wp_users_with_amelia_customer_role'        => __('No WordPress users with the Amelia Customer role are available.', 'wpamelia'),
            'red_notifications'                                => __('Notifications', 'wpamelia'),
            'red_occupancy_rate_info'                          => __('This widget shows monthly data instead of using the global date range.', 'wpamelia'),
            'red_occupancy_rate'                               => __('Occupancy rate', 'wpamelia'),
            'red_occupied'                                     => __('Occupied', 'wpamelia'),
            'red_on_site_payment'                              => __('On-site payment', 'wpamelia'),
            'red_organizers'                                   => __('Organizers', 'wpamelia'),
            'red_payment_methods'                              => __('Payment methods', 'wpamelia'),
            'red_payment_methods_compatibility_rules'          => __('Some payment methods cannot be used together due to compatibility rules', 'wpamelia'),
            'red_outlook_calendar_and_microsoft_teams'         => __('Outlook Calendar & Microsoft Teams', 'wpamelia'),
            'red_paragraph'                                    => __('Paragraph', 'wpamelia'),
            'red_placeholder_tooltip'                          => __('Select a placeholder to insert it where your cursor is placed.', 'wpamelia'),
            'red_plans'                                        => __('Plans', 'wpamelia'),
            'red_please_enter_content'                         => __('Please enter a content.', 'wpamelia'),
            'red_please_enter_notification_name'               => __('Please enter a notification name.', 'wpamelia'),
            'red_please_enter_subject'                         => __('Please enter a subject.', 'wpamelia'),
            'red_please_enter_ticket_name'                     => __('Please enter a ticket name.', 'wpamelia'),
            'red_recaptcha'                                    => __('reCAPTCHA', 'wpamelia'),
            'red_recurring_alert_setup'                        => __('Before enabling the recurring option, ensure that all required fields are set, including the service, employee, date, time, and location (if applicable).', 'wpamelia'),
            'red_reorder_on_website'                           => __('Reorder on website', 'wpamelia'),
            'red_reorder_services_description'                 => __('Reordering services affects how they are displayed on the website.', 'wpamelia'),
            'red_reorder_services'                             => __('Reorder Services', 'wpamelia'),
            'red_replace'                                      => __('Replace', 'wpamelia'),
            'red_revenue_prev_range'                           => __('Previous range', 'wpamelia'),
            'red_revenue_this_range'                           => __('This range', 'wpamelia'),
            'red_roles_permissions'                            => __('Roles & permissions', 'wpamelia'),
            'red_same_day'                                     => __('Same day', 'wpamelia'),
            'red_sat'                                          => __('Sat', 'wpamelia'),
            'red_scheduled'                                    => __('Scheduled', 'wpamelia'),
            'red_scope'                                        => __('Scope', 'wpamelia'),
            'red_scopes'                                       => __('Scopes', 'wpamelia'),
            'red_search_bookings'                              => __('Search bookings', 'wpamelia'),
            'red_search_features'                              => __('Search features', 'wpamelia'),
            'red_search_integrations'                          => __('Search integrations', 'wpamelia'),
            'red_search_invoices'                              => __('Search invoices', 'wpamelia'),
            'red_search_notifications'                         => __('Search notifications', 'wpamelia'),
            'red_search_packages'                              => __('Search packages', 'wpamelia'),
            'red_search_services'                              => __('Search services', 'wpamelia'),
            'red_select_attendee_warning'                      => __('Please select an attendee.', 'wpamelia'),
            'red_select_booking_closes_date_warning'           => __('Please select a closing date.', 'wpamelia'),
            'red_select_booking_closes_time_warning'           => __('Please select a closing time.', 'wpamelia'),
            'red_select_booking_opens_date_warning'            => __('Please select an opening date.', 'wpamelia'),
            'red_select_booking_opens_time_warning'            => __('Please select an opening time.', 'wpamelia'),
            'red_select_box'                                   => __('Select box', 'wpamelia'),
            'red_select_color_warning'                         => __('Please select a color.', 'wpamelia'),
            'red_select_date_range_warning'                    => __('Please select a date range.', 'wpamelia'),
            'red_select_end_time_warning'                      => __('Please select an end time.', 'wpamelia'),
            'red_select_event_warning'                         => __('Please select an event.', 'wpamelia'),
            'red_select_start_time_warning'                    => __('Please select a start time.', 'wpamelia'),
            'red_send_test'                                    => __('Send test', 'wpamelia'),
            'red_service_asc'                                  => __('Service Asc', 'wpamelia'),
            'red_service_categories'                           => __('Service Categories', 'wpamelia'),
            'red_service_desc'                                 => __('Service Desc', 'wpamelia'),
            'red_service_event'                                => __('Service/Event', 'wpamelia'),
            'red_service_updated_success'                      => __('Service has been updated.', 'wpamelia'),
            'red_services_count'                               => __('{count} Service | {count} Services', 'wpamelia'),
            'red_show_bookings'                                => __('Show bookings', 'wpamelia'),
            'red_show_event'                                   => __('Show event', 'wpamelia'),
            'red_show_event_subtitle'                          => __('Are you sure you want to show this event?', 'wpamelia'),
            'red_show_in_calendar'                             => __('View in Calendar', 'wpamelia'),
            'red_single_booking'                               => __('Single booking', 'wpamelia'),
            'red_sms'                                          => __('SMS', 'wpamelia'),
            'red_sms_balance'                                  => __('SMS balance', 'wpamelia'),
            'red_sms_settings'                                 => __('SMS Settings', 'wpamelia'),
            'red_spots'                                        => __('Spots', 'wpamelia'),
            'red_booked'                                       => __('Booked', 'wpamelia'),
            'red_start_date'                                   => __('Start date', 'wpamelia'),
            'red_status_asc'                                   => __('Status Asc', 'wpamelia'),
            'red_status_desc'                                  => __('Status Desc', 'wpamelia'),
            'red_studios'                                      => __('Studios', 'wpamelia'),
            'red_subject_placeholders'                         => __('Subject placeholders', 'wpamelia'),
            'red_sun'                                          => __('Sun', 'wpamelia'),
            'red_support'                                      => __('Support', 'wpamelia'),
            'red_thu'                                          => __('Thu', 'wpamelia'),
            'red_time_zones'                                   => __('Time zones', 'wpamelia'),
            'red_tip_appointment_management_guide'             => __('Appointment management guide', 'wpamelia'),
            'red_tip_custom_service_duration'                  => __('Custom service duration', 'wpamelia'),
            'red_tip_event_calendar_booking_from'              => __('Event calendar booking from', 'wpamelia'),
            'red_tip_event_list_booking_from'                  => __('Event list booking from', 'wpamelia'),
            'red_tip_event_management_guide'                   => __('Events setup', 'wpamelia'),
            'red_tip_event_pricing_setup'                      => __('Events custom pricing', 'wpamelia'),
            'red_tip_event_ticketing'                          => __('Event ticketing', 'wpamelia'),
            'red_tip_events_list_view'                         => __('Events list view', 'wpamelia'),
            'red_tip_events_pricing'                           => __('Events pricing', 'wpamelia'),
            'red_tip_front_end_customer_panel'                 => __('Front-end customer panel', 'wpamelia'),
            'red_tip_importing_customers'                      => __('Importing customers', 'wpamelia'),
            'red_tip_notification_settings'                    => __('Notification settings', 'wpamelia'),
            'red_tip_notifications_in_amelia'                  => __('Notifications in Amelia', 'wpamelia'),
            'red_tip_recurring_appointments_setup'             => __('Recurring appointments setup', 'wpamelia'),
            'red_tip_recurring_events_description'             => __('Create and manage recurring events with customizable schedules for flexibility and convenience.', 'wpamelia'),
            'red_tip_recurring_events'                         => __('Recurring events', 'wpamelia'),
            'red_tip_services_categories_setup'                => __('Services & categories setup', 'wpamelia'),
            'red_tip_services_setup'                           => __('Services setup', 'wpamelia'),
            'red_tip_step_by_step_booking_form_guide'          => __('Step-by-step booking form guide', 'wpamelia'),
            'red_tips_and_suggestions'                         => __('Tips & suggestions', 'wpamelia'),
            'red_total_capacity'                               => __('Total capacity', 'wpamelia'),
            'red_trainers'                                     => __('Trainers', 'wpamelia'),
            'red_transaction'                                  => __('Transaction', 'wpamelia'),
            'red_transaction_details'                          => __('Transaction details', 'wpamelia'),
            'red_transaction_number_count'                     => __('Transaction #{count}', 'wpamelia'),
            'red_transactions'                                 => __('Transactions', 'wpamelia'),
            'red_try_adjusting_search'                         => __('Try adjusting your search to find what you are looking for.', 'wpamelia'),
            'red_tue'                                          => __('Tue', 'wpamelia'),
            'red_update_service_settings'                      => __('Update Service Settings', 'wpamelia'),
            'red_updates'                                      => __('Updates', 'wpamelia'),
            'red_upgrade'                                      => __('Upgrade', 'wpamelia'),
            'red_upload_avatar'                                => __('Upload image', 'wpamelia'),
            'red_upload'                                       => __('Upload', 'wpamelia'),
            'red_videos'                                       => __('Videos', 'wpamelia'),
            'red_view_booking'                                 => __('View booking', 'wpamelia'),
            'red_view_invoice'                                 => __('View invoice', 'wpamelia'),
            'red_watch_tutorials'                              => __('Video tutorials', 'wpamelia'),
            'red_web'                                          => __('Web', 'wpamelia'),
            'red_webhooks'                                     => __('Webhooks', 'wpamelia'),
            'red_wed'                                          => __('Wed', 'wpamelia'),
            'red_wellness'                                     => __('Wellness', 'wpamelia'),
            'red_whatsapp'                                     => __('WhatsApp', 'wpamelia'),
            'red_working_hours'                                => __('Working hours', 'wpamelia'),
            'red_yoga'                                         => __('Yoga', 'wpamelia'),
            'top_trends'                                       => __('Top trends', 'wpamelia'),
            'red_no_customers_title'                           => __('No customers yet', 'wpamelia'),
            'red_no_customers_subtitle_1'                      => __('Once you start receiving bookings, your customers will be displayed here. You can also get started by clicking the Add button below.', 'wpamelia'),
            'red_tip_customer_setup'                           => __('Customer setup', 'wpamelia'),
            'red_how_to'                                       => __('How to', 'wpamelia'),
            'red_packages_locked_heading'                      => __('Boost revenue with bundled service packages', 'wpamelia'),
            'red_packages_locked_description'                  => __('Turn your services into high-value packages that customers love. Combine multiple appointments into a single, discounted offer that drives bigger, more confident purchases.', 'wpamelia'),
            'red_packages_feature_1'                           => __('Increase sales volume by encouraging customers to book more appointments at once', 'wpamelia'),
            'red_packages_feature_2'                           => __('Flexible pricing lets you set a fixed package price and offer attractive discounts', 'wpamelia'),
            'red_packages_feature_3'                           => __('Improved customer retention as clients return to use the remaining sessions in their package', 'wpamelia'),
            'red_resources_locked_heading'                     => __('Manage shared resources with ease', 'wpamelia'),
            'red_resources_locked_description'                 => __('Create rooms, equipment, or other resources that can be shared across employees, services, or locations, ensuring customers only see time slots when everything they need is truly available.', 'wpamelia'),
            'red_resources_feature_1'                          => __('Avoid double-booking by automatically coordinating shared rooms, equipment, or tools', 'wpamelia'),
            'red_resources_feature_2'                          => __('Streamline operations with one central place to manage all resources across your business', 'wpamelia'),
            'red_resources_feature_3'                          => __('Deliver a smoother booking experience by showing customers only real, available time slots', 'wpamelia'),
            'red_extras_locked_heading'                        => __('Boost revenue with valuable extras', 'wpamelia'),
            'red_extras_locked_description'                    => __('Offer optional or mandatory extras during the booking process - upsell additional services, products, or experiences to enhance appointments and delight your customers.', 'wpamelia'),
            'red_extras_feature_1'                             => __('Increase revenue by encouraging customers to purchase additional services or products', 'wpamelia'),
            'red_extras_feature_2'                             => __('Customize offerings to match specific services and meet diverse client needs', 'wpamelia'),
            'red_extras_feature_3'                             => __('Enhance the customer experience with tailored add-ons that add convenience and value', 'wpamelia'),
            'red_locations_locked_heading'                     => __('Effortless management for every location', 'wpamelia'),
            'red_locations_locked_description'                 => __('Easily organize multiple business locations in one place, ensuring smooth operations and a consistent booking experience no matter where your services are offered.', 'wpamelia'),
            'red_locations_feature_1'                          => __('Centralize scheduling across all branches for clearer, simpler management', 'wpamelia'),
            'red_locations_feature_2'                          => __('Improve customer experience by letting clients choose the location that suits them best', 'wpamelia'),
            'red_locations_feature_3'                          => __('Keep operations aligned with unified settings, availability, and resource control', 'wpamelia'),
            'red_custom_fields_locked_heading'                 => __('Collect the information your business truly needs', 'wpamelia'),
            'red_custom_fields_locked_description'             => __('Build tailored forms across services, events, and customer profiles using custom fields. Capture exactly the details you need with checkboxes, text areas, and more, turning every booking and registration into a powerful intake process.', 'wpamelia'),
            'red_custom_fields_feature_1'                      => __('Customize every interaction by gathering the right information for services, events, and customer records', 'wpamelia'),
            'red_custom_fields_feature_2'                      => __('Keep your data organized and meaningful with structured fields that standardize the information you collect', 'wpamelia'),
            'red_custom_fields_feature_3'                      => __('Enhance the customer experience with clear, intuitive forms designed around your business needs', 'wpamelia'),
            'red_invoices_locked_heading'                      => __('Automated invoices for a smoother payment experience', 'wpamelia'),
            'red_invoices_locked_description'                  => __('Automatically generate invoices for every booking, making payments easier, more transparent, and fully streamlined for both you and your clients.', 'wpamelia'),
            'red_invoices_feature_1'                           => __('Save time and reduce manual work with instant, auto-generated invoices', 'wpamelia'),
            'red_invoices_feature_2'                           => __('Improve accuracy and professionalism with consistent, clearly formatted billing', 'wpamelia'),
            'red_invoices_feature_3'                           => __('Enhance client trust by providing transparent, documented payment details for every booking', 'wpamelia'),
            'red_coupons_locked_heading'                       => __('Drive bookings with irresistible coupon offers', 'wpamelia'),
            'red_coupons_locked_description'                   => __('Create unique coupon codes that customers can redeem during booking-offer discounts or even free appointments to boost engagement, satisfaction, and sales.', 'wpamelia'),
            'red_coupons_feature_1'                            => __('Increase conversions by motivating customers with attractive, limited-time deals', 'wpamelia'),
            'red_coupons_feature_2'                            => __('Flexible discount options let you set custom values or offer full-price waivers', 'wpamelia'),
            'red_coupons_feature_3'                            => __('Enhance customer loyalty by rewarding clients with exclusive, personalized offers', 'wpamelia'),
            'red_taxes_locked_heading'                         => __('Effortless tax management for every booking', 'wpamelia'),
            'red_taxes_locked_description'                     => __('Automatically calculate and apply taxes to your services and events, ensuring accurate billing and hassle-free compliance with every transaction.', 'wpamelia'),
            'red_taxes_feature_1'                              => __('Eliminate manual calculations with smart, automated tax application', 'wpamelia'),
            'red_taxes_feature_2'                              => __('Ensure accurate billing by applying the correct tax rates every time', 'wpamelia'),
            'red_taxes_feature_3'                              => __('Stay compliant with ease through consistent, reliable tax handling across your business', 'wpamelia'),
            'red_whatsapp_locked_heading'                      => __('Stay connected with WhatsApp notifications', 'wpamelia'),
            'red_whatsapp_locked_description'                  => __('Keep customers and employees informed by sending appointment and event notifications directly through WhatsApp - choose predefined messages or customize your own for a personal touch.', 'wpamelia'),
            'red_whatsapp_feature_1'                           => __('Boost engagement by reaching clients instantly on a platform they use every day', 'wpamelia'),
            'red_whatsapp_feature_2'                           => __('Reduce no-shows with timely reminders sent automatically', 'wpamelia'),
            'red_whatsapp_feature_3'                           => __('Simplify communication with customizable messages for both customers and employees', 'wpamelia'),
            'red_recurring_events_locked_heading'              => __('Simplify scheduling with recurring events', 'wpamelia'),
            'red_recurring_events_locked_description'          => __('Effortlessly set up and manage events that repeat on your preferred schedule-offering flexibility, consistency, and a smooth experience for both your business and your customers.', 'wpamelia'),
            'red_recurring_events_feature_1'                   => __('Save time by automating repeating events instead of creating them manually', 'wpamelia'),
            'red_recurring_events_feature_2'                   => __('Maintain consistent scheduling with customizable frequencies and patterns', 'wpamelia'),
            'red_recurring_events_feature_3'                   => __('Improve customer convenience by offering predictable, easy-to-book recurring options', 'wpamelia'),
            'red_employee_integrations_locked_heading'         => __('Empower your team with seamless integrations', 'wpamelia'),
            'red_employee_integrations_locked_description'     => __('Connect employee calendars, meeting tools, and other integrations to keep schedules perfectly synced and communication effortless across your entire team.', 'wpamelia'),
            'red_employee_integrations_feature_1'              => __('Prevent scheduling conflicts with real-time calendar syncing for every employee.', 'wpamelia'),
            'red_employee_integrations_feature_2'              => __('Streamline virtual meetings by integrating popular meeting platforms directly into bookings.', 'wpamelia'),
            'red_employee_integrations_feature_3'              => __('Boost team productivity with automated updates and fewer manual tasks.', 'wpamelia'),
            'red_learn_more'                                   => __('Learn more', 'wpamelia'),
            'red_no_employees_yet'                             => __('No employees yet', 'wpamelia'),
            'red_no_employees_subtitle_1'                      => __('Once you add your first employee, it will appear here. Click + Employee below to get started.', 'wpamelia'),
            'red_attendees_search_placeholder'                 => __('Search attendees', 'wpamelia'),
            'red_total_payments'                               => __('Total payments', 'wpamelia'),
            'red_event_booking_closes_at'                      => __('Closes at', 'wpamelia'),
            'red_booking_source'                               => __('Booking source', 'wpamelia'),
            'red_edit_event_booking'                           => __('Edit event booking', 'wpamelia'),
            'red_availability'                                 => __('Availability', 'wpamelia'),
            'red_employee_details'                             => __('Employee details', 'wpamelia'),
            'red_show_more_count'                              => __('Show more ({count})', 'wpamelia'),
            'red_actions'                                      => __('Actions', 'wpamelia'),
            'red_tip_employee_setup'                           => __('Employee setup', 'wpamelia'),
            'red_tip_managing_assigned_services'               => __('Managing assigned services', 'wpamelia'),
            'red_tip_special_days_setup'                       => __('Special days setup', 'wpamelia'),
            'red_tip_setting_up_days_off'                      => __('Setting up days off', 'wpamelia'),
            'red_tip_employee_badges_management'               => __('Employee badges management', 'wpamelia'),
            'red_tip_google_meet_setup'                        => __('Google Meet setup', 'wpamelia'),
            'red_tip_work_hours_setup'                         => __('Work hours setup', 'wpamelia'),
            'red_all_assigned_services'                        => __('All assigned services', 'wpamelia'),
            'red_default_location'                             => __('Default location', 'wpamelia'),
            'red_tip_zoom_setup'                               => __('Zoom setup', 'wpamelia'),
            'red_tip_front_end_employee_panel'                 => __('Front-end employee panel', 'wpamelia'),
            'red_tip_roles_settings'                           => __('Roles settings', 'wpamelia'),
            'red_hide_service'                                 => __('Hide service', 'wpamelia'),
            'red_duplicate_service'                            => __('Duplicate service', 'wpamelia'),
            'red_duplicate_category'                           => __('Duplicate category', 'wpamelia'),
            'red_delete_category_effect_future'                => __('Could not delete category. This category has services with {count} future appointment. | Could not delete category. This category has services with {count} future appointments.', 'wpamelia'),
            'red_delete_category_effect_past'                  => __('This category has services with {count} past appointment. | This category has services with {count} past appointments.', 'wpamelia'),
            'red_delete_service_effect_future'                 => __('Could not delete service. This service has {count} appointment in the future. | Could not delete service. This service has {count} appointments in the future.', 'wpamelia'),
            'red_hide_employee'                                => __('Hide employee', 'wpamelia'),
            'red_show_employee'                                => __('Show employee', 'wpamelia'),
            'red_delete_customer'                              => __('Delete customer', 'wpamelia'),
            'red_delete_employee'                              => __('Delete employee', 'wpamelia'),
            'red_delete_user_effect_future'                    => __('Could not delete user. This user has {count} appointment in the future. | Could not delete user. This user has {count} appointments in the future.', 'wpamelia'),
            'red_block_customer'                               => __('Block customer', 'wpamelia'),
            'red_unblock_customer'                             => __('Unblock customer', 'wpamelia'),
            'red_hide_event'                                   => __('Hide event', 'wpamelia'),
            'red_hide_event_subtitle'                          => __('Are you sure you want to hide this event?', 'wpamelia'),
            'red_event_cancel_delete'                          => __('Are you sure you want to cancel and delete this event?', 'wpamelia'),
            'red_confirm_delete_event_booking'                 => __('Are you sure you want to delete this event booking?', 'wpamelia'),
            'red_notification_status_updated'                  => __('Notification status has been updated.', 'wpamelia'),
            'red_notification_status_failed'                   => __('Notification status has not been updated.', 'wpamelia'),
            'red_draft'                                        => __('Draft', 'wpamelia'),
            'red_customers_deleted_success'                    => __('{count} customer deleted. | {count} customers deleted.', 'wpamelia'),
            'red_event_hidden'                                 => __('Event has been hidden.', 'wpamelia'),
            'red_event_visible'                                => __('Event is now visible.', 'wpamelia'),
            'red_customer_details'                             => __('Customer details', 'wpamelia'),
            'red_last_on'                                      => __('Last on {date}', 'wpamelia'),
            'red_customers_deleted_error'                      => __('{count} customer could not be deleted due to future bookings. | {count} customers could not be deleted due to future bookings.', 'wpamelia'),
            'red_customer_updated_success'                     => __('Customer has been updated.', 'wpamelia'),
            'red_watch_on_youtube'                             => __('Watch on YouTube', 'wpamelia'),
            'red_repeat_every_year'                            => __('Repeat every year', 'wpamelia'),
            'red_edit_work_hours'                              => __('Edit work hours', 'wpamelia'),
            'red_edit_day_off'                                 => __('Edit day off', 'wpamelia'),
            'red_hide_tips_and_suggestions'                    => __('Hide tips & suggestions', 'wpamelia'), // Used in Redesign | Update
            'red_export_appointments_locked_title'             => __('Export appointment data with ease', 'wpamelia'),
            'red_export_appointments_locked_description'       => __('Quickly download all appointment details from the Bookings page, making reporting, analysis, and record-keeping simple and efficient.', 'wpamelia'),
            'red_export_appointments_locked_feature_1'         => __('Save time with fast, one-click appointment exports', 'wpamelia'),
            'red_export_appointments_locked_feature_2'         => __('Improve reporting accuracy by accessing complete appointment data instantly', 'wpamelia'),
            'red_export_appointments_locked_feature_3'         => __('Stay organized with export files ready for analysis or external tools', 'wpamelia'),
            'red_export_customers_locked_title'                => __('Easily export your customer data in one click', 'wpamelia'),
            'red_export_customers_locked_description'          => __('Download your customer list instantly for reporting, marketing, or external system use, making data management faster and more convenient than ever.', 'wpamelia'),
            'red_export_customers_locked_feature_1'            => __('Save time with quick, hassle-free customer data exports', 'wpamelia'),
            'red_export_customers_locked_feature_2'            => __('Support deeper insights by using exported data for analysis and reporting', 'wpamelia'),
            'red_export_customers_locked_feature_3'            => __('Enhance flexibility with customer information ready for marketing tools or external platforms', 'wpamelia'),
            'red_custom_notifications_locked_title'            => __('Send smart, personalized notifications your way', 'wpamelia'),
            'red_custom_notifications_locked_description'      => __('Create custom notifications that trigger based on booking status or schedule reminders, keeping customers and employees informed at exactly the right time.', 'wpamelia'),
            'red_custom_notifications_locked_feature_1'        => __('Automate communication with notifications triggered by booking status, time, or custom rules', 'wpamelia'),
            'red_custom_notifications_locked_feature_2'        => __('Keep everyone on track using scheduled reminders that reduce no-shows and confusion', 'wpamelia'),
            'red_custom_notifications_locked_feature_3'        => __('Deliver personalized messages tailored to your business tone, branding, and workflow', 'wpamelia'),
            'red_export_payments_locked_title'                 => __('Access your financial data in seconds', 'wpamelia'),
            'red_export_payments_locked_description'           => __('Export all transaction records from the Finance page for effortless accounting, reconciliation, or sharing with your finance tools.', 'wpamelia'),
            'red_export_payments_locked_feature_1'             => __('Simplify financial management with easy, one-click transaction exports', 'wpamelia'),
            'red_export_payments_locked_feature_2'             => __('Ensure accurate bookkeeping with clear, organized financial data', 'wpamelia'),
            'red_export_payments_locked_feature_3'             => __('Support external workflows by seamlessly moving financial records into other systems', 'wpamelia'),
            'red_multiple_employees_locked_title'              => __('Grow your team with unlimited employee management', 'wpamelia'),
            'red_multiple_employees_locked_description'        => __('Add multiple employees to your booking system, manage their schedules, and assign them to services or events, making it easy to scale your business and coordinate your team.', 'wpamelia'),
            'red_multiple_employees_locked_feature_1'          => __('Expand your capacity by adding as many employees as your business needs', 'wpamelia'),
            'red_multiple_employees_locked_feature_2'          => __('Simplify scheduling with individual availability, working hours, and assignments', 'wpamelia'),
            'red_multiple_employees_locked_feature_3'          => __('Improve customer choice by letting clients book with the employee that suits them best', 'wpamelia'),
            'red_notification'                                 => __('Notification', 'wpamelia'),
            'red_confirm_delete_event'                         => __('Are you sure you want to delete this event?', 'wpamelia'),
            'red_delete_category'                              => __('Delete category', 'wpamelia'),
            'red_delete_service'                               => __('Delete service', 'wpamelia'),
            'red_configuration'                                => __('Configuration', 'wpamelia'),
            'red_delete_user_effect_past'                      => __('This user has {count} appointment in the past. | This user has {count} appointments in the past.', 'wpamelia'),
            'red_delete_user_event_effect_future'              => __('This user is an attendee in future event. Are you sure you want to delete this user? | This user is an attendee in future events. Are you sure you want to delete this user?', 'wpamelia'),
            'red_no_wp_users_with_amelia_employee_role'        => __('No WordPress users with the Amelia Employee role are available.', 'wpamelia'),
            'red_set_up'                                       => __('Set up', 'wpamelia'),
            'red_disable'                                      => __('Disable', 'wpamelia'),
            'enter_email_then_press_enter_to_add'              => __('Enter email, then press Enter to add', 'wpamelia'),
            'payment_links_warning'                            => __('This option requires adding the payment link placeholder to your message templates.', 'wpamelia'), // Used in Redesign | Updated
            'payment_links_redirect'                           => __('Redirect URL after payment', 'wpamelia'), // Used in Redesign | Updated
            'payment_links_redirect_tooltip'                   => __('Customers will be redirected to this URL after they complete their payment.', 'wpamelia'), // Used in Redesign | Updated
            'basic'                                            => __('Basic', 'wpamelia'),
            'advanced'                                         => __('Advanced', 'wpamelia'),
            'field_options'                                    => __('Options', 'wpamelia'), // Used in Redesign
            'field_order'                                      => __('Field order', 'wpamelia'), // Used in Redesign
            'button'                                           => __('Button', 'wpamelia'), // Used in Redesign
            'language'                                         => __('Language', 'wpamelia'), // Used in Redesign
            'go_to_sbs_form'                                   => __('Go to Step-by-step form', 'wpamelia'), // Used in Redesign
            'go_to_cat_form'                                   => __('Go to Catalog form', 'wpamelia'), // Used in Redesign
            'redirect'                                         => __('Redirect', 'wpamelia'), // Used in Redesign
            'save_data_on_redirect'                            => __('Your data will be saved before redirecting to another form.', 'wpamelia'), // Used in Redesign
            'steps_order'                                      => __('Steps order', 'wpamelia'), // Used in Redesign
            'labels'                                           => __('Labels', 'wpamelia'), // Used in Redesign
            'forms_picker'                                     => __('Forms', 'wpamelia'), // Used in Redesign
            'accent'                                           => __('Accent', 'wpamelia'), // Used in Redesign
            'accent_text'                                      => __('Accent text', 'wpamelia'), // Used in Redesign
            'secondary'                                        => __('Secondary', 'wpamelia'), // Used in Redesign
            'secondary_text'                                   => __('Secondary text', 'wpamelia'), // Used in Redesign
            'body_text'                                        => __('Body text', 'wpamelia'), // Used in Redesign
            'publish'                                          => __('Publish', 'wpamelia'),
            'red_employee_added_success'                       => __('Employee has been created.', 'wpamelia'),
            'red_employee_updated_success'                     => __('Employee has been updated.', 'wpamelia'),
            'employee_deleted'                                 => __('Employee has been deleted.', 'wpamelia'), // Used in Redesign | Updated
            'red_update'                                       => __('Update', 'wpamelia'),
            'background'                                       => __('Background', 'wpamelia'), // Used in Redesign
            'outline'                                          => __('Outline', 'wpamelia'), // Used in Redesign
            'placeholder_text'                                 => __('Placeholder text', 'wpamelia'), // Used in Redesign
            'available_date_background'                        => __('Available date background', 'wpamelia'), // Used in Redesign
            'available_date_text'                              => __('Available date text', 'wpamelia'), // Used in Redesign
            'selected_date_background'                         => __('Selected date background', 'wpamelia'), // Used in Redesign
            'selected_date_text'                               => __('Selected date text', 'wpamelia'), // Used in Redesign
            'unavailable_date_background'                      => __('Unavailable date background', 'wpamelia'), // Used in Redesign
            'unavailable_date_text'                            => __('Unavailable date text', 'wpamelia'),
            'employee_description'                             => __('Employee description popup', 'wpamelia'),
            'content_area'                                     => __('Content area', 'wpamelia'), // Used in Redesign
            'filters'                                          => __('Filters', 'wpamelia'),
            'red_categories_positions_failed'                  => __('Failed to update category positions.', 'wpamelia'),
            'red_category_added_success'                       => __('Category has been created.', 'wpamelia'),
            'red_category_updated_success'                     => __('Category has been updated.', 'wpamelia'),
            'red_customer_added_success'                       => __('Customer has been created.', 'wpamelia'),
            'red_event_booking_updated_success'                => __('Event booking has been updated.', 'wpamelia'),
            'red_event_created_success'                        => __('Event has been created.', 'wpamelia'),
            'red_event_updated_success'                        => __('Event has been updated.', 'wpamelia'),
            'red_event_booking_created_success'                => __('Event booking has been created.', 'wpamelia'),
            'red_service_added_success'                        => __('Service has been added.', 'wpamelia'),
            'csb_events_calendar'                              => __('Events calendar', 'wpamelia'),
            'csb_event_tickets'                                => __('Event tickets', 'wpamelia'),
            'upcoming_events_block'                            => __('Upcoming events section', 'wpamelia'),
            'step_search'                                      => __('Search', 'wpamelia'),
            'customer_panel_btn'                               => __('\'Customer panel\' button style', 'wpamelia'),
            'step_heading'                                     => __('Step heading', 'wpamelia'),
            'event_today'                                      => __('Today', 'wpamelia'),
            'event_no_spots'                                   => __('No spots left', 'wpamelia'),
            'evt_empty_message'                                => __('There are no upcoming events for this period', 'wpamelia'),
            'taxes'                                            => __('Taxes', 'wpamelia'), // Used in Redesign
            'title_text'                                       => __('Title text', 'wpamelia'), // Used in Redesign
            'info_text'                                        => __('Info text', 'wpamelia'), // Used in Redesign
            'primary_button_type'                              => __('Primary button style', 'wpamelia'),
            'secondary_button_type'                            => __('Secondary button style', 'wpamelia'),
            'font_family'                                      => __('Font family', 'wpamelia'),
        ];
    }
}
